% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bootmlx}
\alias{bootmlx}
\title{Bootstrapping - case resampling}
\usage{
bootmlx(
  project,
  nboot = 100,
  dataFolder = NULL,
  parametric = FALSE,
  tasks = c(populationParameterEstimation = TRUE),
  settings = NULL
)
}
\arguments{
\item{project}{Monolix project}

\item{nboot}{[optional] number of bootstrap replicates (default=100)}

\item{dataFolder}{[optional] folder where already generated datasets are stored, e.g dataFolder="./dummy_project/boot/" (default: data set are generated by bootmlx)}

\item{parametric}{[optional] boolean to define if parametric bootstrap is performed (new data is drawn from the model), (default: false)}

\item{tasks}{[optional] vector of booleans defining the list of tasks to perform (default: estimation of the population parameters)
available tasks: populationParameterEstimation, conditionalDistributionSampling,
conditionalModeEstimation, standardErrorEstimation, logLikelihoodEstimation, plots}

\item{settings}{[optional] a list of settings for the resampling and the results:
\itemize{
\item \code{N} the number of individuals in each bootstrap data set 
(default value is the  number of individuals in the original data set).
\item \code{newResampling} boolean to generate the data sets again if they already exist (default=FALSE).
\item \code{covStrat} a categorical covariate of the project. The original distribution of this covariate
is maintained in each resampled data set if covStrat is defined (default=NULL). Notice that if the categorical covariate is varying 
within the subject (in case of IOV), it will not be taken into account.
\item \code{plot} boolean to choose if the distribution of the bootstraped esimates is displayed
(default = FALSE)
\item \code{level} level of the bootstrap confidence intervals of the population parameters
(default = 0.90)
\item \code{seed} a positive integer < 2147483647, seed for the generation of the data sets (default = NA)
\item \code{deleteData} delete created data set files after estimation (default = FALSE)
\item \code{deleteProjects} delete created Monolix projects after estimation (default = FALSE)
}}
}
\value{
a data frame with the bootstrap estimates
}
\description{
Generate replicates of the original data using random sampling with replacement.
Population parameters are then estimated from each replicate.
}
\examples{
\dontrun{
# RsmlxDemo1.mlxtran is a Monolix project for modelling the PK of warfarin using a PK model 
# with parameters ka, V, Cl.

# In this example, bootmlx will generate 100 random replicates of the original data and will
# use Monolix to estimate the population parameters from each of these 100 replicates:
r1 <- bootmlx(project="RsmlxDemo1.mlxtran")
  
# 5 replicates will now be generated, with 50 individuals in each replicate:
r2 <- bootmlx(project="RsmlxDemo1.mlxtran",  nboot = 5, settings = list(N = 50))

# Proportions of males and females in the original dataset will be preserved   
# in each replicate:
r3 <- bootmlx(project="RsmlxDemo1.mlxtran",  settings = list(covStrat = "sex"))
}

# See http://monolix.lixoft.com/rsmlx/bootmlx/ for detailed examples of use of bootmlx
# Download the demo examples here: http://monolix.lixoft.com/rsmlx/installation


}
