% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solnp.R
\name{solnp}
\alias{solnp}
\title{Nonlinear optimization using augmented Lagrange method (original version)}
\usage{
solnp(
  pars,
  fun,
  eqfun = NULL,
  eqB = NULL,
  ineqfun = NULL,
  ineqLB = NULL,
  ineqUB = NULL,
  LB = NULL,
  UB = NULL,
  control = list(),
  ...
)
}
\arguments{
\item{pars}{an numeric vector of decision variables (length n).}

\item{fun}{the objective function (must return a scalar).}

\item{eqfun}{an optional function for calculating equality constraints.}

\item{eqB}{a vector of the equality bounds (if eq_fn provided).}

\item{ineqfun}{an optional function for calculating inequality constraints.}

\item{ineqLB}{the lower bounds for the inequality (must be finite)}

\item{ineqUB}{the upper bounds for the inequalitiy (must be finite)}

\item{LB}{lower bounds on decision variables}

\item{UB}{upper bounds on decision variables}

\item{control}{a list of solver control parameters (see details).}

\item{...}{additional arguments passed to the supplied functions (common to all functions supplied).}
}
\value{
An list with the following slot:
\describe{
\item{pars}{Optimal Parameters.}
\item{convergence }{Indicates whether the solver has converged (0) or not (1 or 2).}
\item{values}{Vector of function values during optimization with last one the
value at the optimal.}
\item{lagrange}{The vector of Lagrange multipliers.}
\item{hessian}{The Hessian of the augmented problem at the optimal solution.}
\item{ineqx0}{The estimated optimal inequality vector of slack variables used
for transforming the inequality into an equality constraint.}
\item{nfuneval}{The number of function evaluations.}
\item{elapsed}{Time taken to compute solution.}
}
}
\description{
Nonlinear optimization using augmented Lagrange method (original version)
}
\details{
The optimization problem solved by \code{csolnp} is formulated as:
\deqn{
\begin{aligned}
\min_{x \in \mathbb{R}^n} \quad & f(x) \\
\text{s.t.} \quad & g(x) = b \\
& h_l \le h(x) \le h_u\\
& x_l \le x \le x_u\\
\end{aligned}
}

where \eqn{f(x)} is the objective function, \eqn{g(x)} is the vector of equality constraints
with target value \eqn{b}, \eqn{h(x)} is the vector of inequality constraints bounded
by \eqn{h_l} and \eqn{h_u}, with parameter bounds \eqn{x_l} and \eqn{x_u}. Internally,
inequality constraints are converted into equality constraints using slack variables
and solved using an augmented Lagrangian approach.
The control is a list with the following options:
\describe{
\item{rho}{This is used as a penalty weighting scaler for infeasibility in the
augmented objective function. The higher its value the more the weighting to
bring the solution into the feasible region (default 1). However, very high
values might lead to numerical ill conditioning or significantly slow down
convergence.}
\item{outer.iter}{Maximum number of major (outer) iterations (default 400).}
\item{inner.iter}{Maximum number of minor (inner) iterations (default 800).}
\item{delta}{Relative step size in forward difference evaluation (default 1.0e-7).}
\item{tol}{ Relative tolerance on feasibility and optimality (default 1e-8).}
\item{trace}{The value of the objective function and the parameters is printed
at every major iteration (default 1).}
}
}
\examples{
{
# From the original paper by Y.Ye
# see the unit tests for more....
# POWELL Problem
fn1 = function(x)
{
    exp(x[1] * x[2] * x[3] * x[4] * x[5])
}
eqn1 = function(x){
    z1 = x[1] * x[1] + x[2] * x[2] + x[3] * x[3] + x[4] * x[4] + x[5] * x[5]
    z2 = x[2] * x[3] - 5 * x[4] * x[5]
    z3 = x[1] * x[1] * x[1] + x[2] * x[2] * x[2]
    return(c(z1, z2, z3))
}
x0 = c(-2, 2, 2, -1, -1)
}
powell = solnp(x0, fun = fn1, eqfun = eqn1, eqB = c(10, 0, -1))
}
\author{
Alexios Galanos
}
\keyword{optimize}
