% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmark_suite.R
\name{solnp_problems_table}
\alias{solnp_problems_table}
\title{List of Valid Test Problems for the SOLNP Suite}
\usage{
solnp_problems_table()
}
\value{
A data.frame with the following columns:
\describe{
\item{Suite}{A character string indicating the suite the problem belongs to.
One of \dQuote{Hock-Schittkowski} or \dQuote{Other}.}
\item{Problem}{The base name of the problem function (without the \sQuote{_problem} suffix).}
\item{Number}{An integer identifier used to index or request problems programmatically.}
}
}
\description{
Returns a data.frame of known and registered test problems used with the SOLNP solver.
The list includes problems from the Hock-Schittkowski suite as well as a selection
of other classic optimization problems.
}
\details{
\itemize{
\item All problem functions are expected to follow the naming convention
\sQuote{Problem_problem} (e.g., \sQuote{hs01_problem}).
\item For Hock-Schittkowski problems, numbers range from 1 to 50, with a few
selected extras (e.g., 110, 118, 119).
\item The \dQuote{Other} suite includes named problems like \sQuote{box},
\sQuote{alkylation}, \sQuote{entropy}, \sQuote{garch}, etc.,
and are numbered sequentially.
}
}
\examples{
# View all known problems
tail(solnp_problems_table())

# Filter only HS problems
head(subset(solnp_problems_table(), Suite == "Hock-Schittkowski"))

}
\seealso{
\code{\link[=solnp_problem_suite]{solnp_problem_suite()}}
}
