% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateSaveCobra.R
\name{updateSaveCobra}
\alias{updateSaveCobra}
\title{Update and save cobra}
\usage{
updateSaveCobra(cobra, ev1, subMin, sigmaD, penaF, gama, EPS, fitFuncPenalRBF,
  distRequirement, fitnessSurrogate = cobra$fitnessSurrogate)
}
\arguments{
\item{cobra}{an object of class COBRA, this is a (long) list containing all settings
from \code{\link{cobraPhaseII}}}

\item{ev1}{a list filled by calls to \code{\link{evalReal}}. We need here the elements xNew,
feas, feasPred, feval, optimizerConvergence, optimizationTime, predY, predVal}

\item{subMin}{see \code{\link{cobraPhaseII}}}

\item{sigmaD}{see \code{\link{cobraPhaseII}}}

\item{penaF}{see \code{\link{cobraPhaseII}}}

\item{gama}{see \code{\link{cobraPhaseII}}}

\item{EPS}{see \code{\link{cobraPhaseII}}}

\item{fitFuncPenalRBF}{helper function from \code{\link{cobraPhaseII}}}

\item{distRequirement}{helper function from \code{\link{cobraPhaseII}}}

\item{fitnessSurrogate}{the model used for \code{predSoluFunc}}
}
\value{
\code{cobra}, an object of class COBRA, 
   enhanced here by the following elements (among others):
     \item{\code{df}}{  data frame with summary of the optimization run (see \code{\link{cobraPhaseII}})}
     \item{\code{df2}}{  data frame with additional summary information (see \code{\link{cobraPhaseII}})}
     \item{\code{dftr}}{  data frame with additional summary information for TR(see \code{\link{cobraPhaseII}})}
     \item{\code{fbest}}{ the best feasible objective value found }
     \item{\code{xbest}}{ the point in input space yielding the best feasible objective value }
     \item{\code{ibest}}{ the corresponding iteration number (row of \code{cobra$df}, of \code{cobra$A}) }
     \item{\code{fbestArray}}{ vector of all \code{fbest} }
     \item{\code{xbestArray}}{ vector of all \code{xbest} }
}
\description{
Helper for \code{\link{cobraPhaseII}}: make some assertion tests, 
update elements in object \code{cobra}, including data frames \code{df} and \code{df2}, 
and - if \code{cobra$saveIntermediate==TRUE} - save cobra in subdir \code{results/}.
Most importantly \code{cobra$xbest, cobra$fbest, cobra$ibest} are updated. They characterize the 
best feasible point (least violating point if no feasible point was found so far) and
influence the next starting point.
}
\details{
Note: the elements \code{A, Fres, Gres} of \code{cobra} are set in \code{updateInfoAndCounters},
an internal function of \code{\link{cobraPhaseII}}.
}
\seealso{
\code{\link{cobraPhaseII}}, \code{\link{cobraInit}}
}
\keyword{internal}
