# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' network_simplex
#' 
#' Function to solve network simplex problem
#'
#' @usage network_simplex(X,Y,D)
#' @param X [Rcpp::NumericVector] Source
#' @param Y [Rcpp::NumericVector] Target
#' @param D [Rcpp::NumericMatrix] Cost
#'
#' @return [Rcpp::List] List containing the plan and if optim is a success
#'
#' @export
network_simplex <- function(X, Y, D) {
    .Call(`_SBCK_network_simplex`, X, Y, D)
}

#' cpp_pairwise_distances_XYstr
#' 
#' Pairwise distances between two differents matrix X and Y with a 
#' compiled str_metric. DO NOT USE, use SBCK::pairwise_distances
#'
#' @usage cpp_pairwise_distances_XYstr(X,Y,str_metric)
#' @param X [Rcpp::NumericMatrix] Matrix
#' @param Y [Rcpp::NumericMatrix] Matrix
#' @param str_metric [std::string] c++ string
#'
#' @export
cpp_pairwise_distances_XYstr <- function(X, Y, str_metric) {
    .Call(`_SBCK_cpp_pairwise_distances_XYstr`, X, Y, str_metric)
}

#' cpp_pairwise_distances_Xstr
#' 
#' Pairwise distances between X and themselves with a compiled 
#' str_metric. DO NOT USE, use SBCK::pairwise_distances
#'
#' @usage cpp_pairwise_distances_Xstr(X,str_metric)
#' @param X [Rcpp::NumericMatrix] Matrix
#' @param str_metric [std::string] c++ string
#'
#' @export
cpp_pairwise_distances_Xstr <- function(X, str_metric) {
    .Call(`_SBCK_cpp_pairwise_distances_Xstr`, X, str_metric)
}

#' cpp_pairwise_distances_XYCall
#' 
#' Pairwise distances between X  and Y with a R function (metric).
#' DO NOT USE, use SBCK::pairwise_distances
#'
#' @usage cpp_pairwise_distances_XYCall(X,Y,metric)
#' @param X [Rcpp::NumericMatrix] Matrix
#' @param Y [Rcpp::NumericMatrix] Matrix
#' @param metric [Rcpp::Function] R function
#'
#' @export
cpp_pairwise_distances_XYCall <- function(X, Y, metric) {
    .Call(`_SBCK_cpp_pairwise_distances_XYCall`, X, Y, metric)
}

#' cpp_pairwise_distances_XCall
#' 
#' Pairwise distances between X and themselves with a R function (metric).
#' DO NOT USE, use SBCK::pairwise_distances
#'
#' @usage cpp_pairwise_distances_XCall(X,metric)
#' @param X [Rcpp::NumericMatrix] Matrix
#' @param metric [Rcpp::Function] R function
#'
#' @export
cpp_pairwise_distances_XCall <- function(X, metric) {
    .Call(`_SBCK_cpp_pairwise_distances_XCall`, X, metric)
}

