% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.DistHelper.R
\name{DistHelper}
\alias{DistHelper}
\title{Dist Helper}
\description{
Class used by CDFt and QM to facilitate fit, do not use
}
\details{
Used to parallel work for margins
}
\examples{
## 
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{dist}}{[ROOPSD distribution] name of class}

\item{\code{law}}{[ROOPSD distribution] class set}

\item{\code{kwargs}}{[list] arguments of dist}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{DistHelper$new()}}
\item \href{#method-set_features}{\code{DistHelper$set_features()}}
\item \href{#method-fit}{\code{DistHelper$fit()}}
\item \href{#method-is_frozen}{\code{DistHelper$is_frozen()}}
\item \href{#method-is_parametric}{\code{DistHelper$is_parametric()}}
\item \href{#method-clone}{\code{DistHelper$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new DistHelper object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DistHelper$new(dist, kwargs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dist}}{[ROOPSD distribution or list] statistical law}

\item{\code{kwargs}}{[list] arguments passed to dist}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `DistHelper` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_features"></a>}}
\if{latex}{\out{\hypertarget{method-set_features}{}}}
\subsection{Method \code{set_features()}}{
set the number of features
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DistHelper$set_features(n_features)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_features}}{[integer] numbers of features}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fit"></a>}}
\if{latex}{\out{\hypertarget{method-fit}{}}}
\subsection{Method \code{fit()}}{
fit the laws
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DistHelper$fit(X, i)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{[matrix] dataset to fit}

\item{\code{i}}{[integer] margins to fit}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_frozen"></a>}}
\if{latex}{\out{\hypertarget{method-is_frozen}{}}}
\subsection{Method \code{is_frozen()}}{
Test if margins i is frozen
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DistHelper$is_frozen(i)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{[integer] margins to fit}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[bool]
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_parametric"></a>}}
\if{latex}{\out{\hypertarget{method-is_parametric}{}}}
\subsection{Method \code{is_parametric()}}{
Test if margins i is parametric
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DistHelper$is_parametric(i)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{[integer] margins to fit}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[bool]
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DistHelper$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
