% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.OTHist.R
\name{OTHist}
\alias{OTHist}
\title{Optimal Transport Histogram}
\description{
Histogram
}
\details{
Just a generic class which contains two arguments, p (probability) and c
(center of bins)
}
\examples{
## Build a random discrete probability distribution
p = stats::rnorm(100)
p = p / base::sum(p)
c = base::seq( -1 , 1 , length = 100 )
mu = OTHist$new( p , c )

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{p}}{[vector] Vector of probability}

\item{\code{c}}{[matrix] Vector of center of bins, with nrow = n_samples and ncol = n_features}

\item{\code{bin_width}}{[vector or NULL] A vector of lengths of the cells
discretizing R^{numbers of variables}. If NULL, it is estimating
during the fit}

\item{\code{bin_origin}}{[vector or NULL] Coordinate of lower corner of one
cell. If NULL, c(0,...,0) is used}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OTHist-new}{\code{OTHist$new()}}
\item \href{#method-OTHist-clone}{\code{OTHist$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OTHist-new"></a>}}
\if{latex}{\out{\hypertarget{method-OTHist-new}{}}}
\subsection{Method \code{new()}}{
Create a new OTHist object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OTHist$new(p, c)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{[vector] Vector of probability}

\item{\code{c}}{[matrix] Vector of center of bins, with nrow = n_samples and ncol = n_features}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `OTHist` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OTHist-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OTHist-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OTHist$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
