% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blockmod.R
\name{blockmod}
\alias{blockmod}
\title{Block Model}
\usage{
blockmod(fixkappa, logd, dcond, r, ...)
}
\arguments{
\item{fixkappa}{Logical - is kappa fixed or can it vary under the model?}

\item{logd}{\code{function(blocks)} - log density for \code{blocks}}

\item{dcond}{\code{function(blocks, i)} - conditional density for the block assignment \code{i} in \code{blocks}}

\item{r}{\code{function(n), sorted=FALSE} - samples a blocks object from the model}

\item{...}{parameters of the model for use in \code{r}, \code{logd}, \code{dcond}}
}
\value{
a \code{blockmod} object
}
\description{
create a \code{blockmod} object
}
\details{
A block model is a probability model for a \code{blocks} object.
This class creates a closure with three functions:
- a random method for sampling block a structure from the model with \code{n} nodes; a
- a log-density method for computing the log-density of a given block structure in a \code{blocks} object
- a conditional density function that takes a \code{blocks} object and a node \code{i}
}
\seealso{
\code{\link{multinom}} \code{\link{dma}} \code{\link{crp}} \code{\link{blocks}}
}
