% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_manipulating_functions.R
\name{filter_keys}
\alias{filter_keys}
\title{Filters .data according to all records in the filter}
\usage{
filter_keys(.data, filters, by = NULL, na_by = NULL)
}
\arguments{
\item{.data}{A data frame, a tibble, a data.table or a tbl.}

\item{filters}{A filter to subset data by.  if filters == NULL, no filtering occurs. Else, an inner_join is performed using all columns of the filter}

\item{by}{passed to inner_join if different from NULL}

\item{na_by}{passed to inner_join if different from NULL}
}
\value{
An object similar to .data
}
\description{
If filter = NULL, not filtering is done
If filter is different from NULL, the .data is filtered by a inner_join using all columns of the filter:
\code{inner_join(.data, filter, by = colnames(filter))}

by and na_by can overwrite the inner_join columns used in the filtering
}
\examples{
# Filtering with null means no filtering is done
filter <- NULL
identical(filter_keys(mtcars, filter), mtcars) # TRUE

# Filtering by vs = 0
filter <- data.frame(vs = 0)
identical(filter_keys(mtcars, filter), dplyr::filter(mtcars, vs == 0)) # TRUE

# Filtering by the specific combinations of vs = 0 and am = 1
filter <- dplyr::distinct(mtcars, vs, am)
filter_keys(mtcars, filter)

}
