#' SCE: Stepwise Clustered Ensemble
#'
#' @description
#' The SCE package provides implementation of Stepwise Clustered Ensemble (SCE) and 
#' Stepwise Cluster Analysis (SCA) methods for multivariate data analysis. These methods 
#' are particularly useful for handling complex, high-dimensional datasets and building 
#' robust predictive models.
#'
#' @details
#' The main functions in the package are:
#' \itemize{
#'   \item \code{\link{SCE}}: Main function for Stepwise Clustered Ensemble analysis
#'   \item \code{\link{SCA}}: Stepwise Cluster Analysis function
#'   \item \code{\link{Model_evaluation}}: Evaluate model performance
#'   \item \code{\link{Model_simulation}}: Perform model simulations
#'   \item \code{\link{RFE_SCE}}: Recursive Feature Elimination for SCE
#'   \item \code{\link{Training}}: Training function for the ensemble model
#'   \item \code{\link{Prediction}}: Make predictions using the trained model
#'   \item \code{\link{Wilks_importance}}: Calculate variable importance using Wilks' lambda
#' }
#'
#' @author
#' Kailong Li \email{lkl98509509@gmail.com}
#'
#' @references
#' For more information about the Stepwise Clustered Ensemble method, please refer to:
#' \itemize{
#'   \item Li, K., et al. (Year). Title of the paper. Journal Name, Volume(Issue), pages.
#' }
#'
#' @docType package
#' @name SCE-package
#' @aliases SCE
NULL 