% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sine_OLS.R
\name{sine_OLS}
\alias{sine_OLS}
\title{Cosine model fitting with proposed initialization.}
\usage{
sine_OLS(data)
}
\arguments{
\item{data}{A data frame that contains the data for one individual. There should be two columns
with names 'distance' and 'oxygen'.}
}
\value{
A fitted model object from the nls function in R:

\item{m}{an 'nlsModel' object incorporating the model.}
\item{convInfo}{a list with convergence information}
\item{data}{the expression that was passed to 'nls' as the data argument. The actual data values are present in the environment of the 'm' component.}
\item{call}{the matched call with several components, notably 'algorithm'}
\item{dataClasses}{the '"dataClasses"' attribute (if any) of the '"terms"' attribute of the model frame.}
\item{control}{the control 'list' used}
}
\description{
Performs the updated nonlinear least squares (NLS) regression method for the cosine
model (see Chazin et al. 2019).
}
\examples{
armenia_split = split(armenia,f = armenia$ID)
sine_OLS(armenia_split[[1]])
}
\references{
Florent Baty, Christian Ritz, Sandrine Charles, Martin Brutsche, Jean-Pierre Flandrois, Marie-Laure Delignette-Muller (2015). A Toolbox for Nonlinear Regression in R: The Package nlstools. Journal of Statistical Software, 66(5), 1-21. URL http://www.jstatsoft.org/v66/i05/.
}
