% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varImp.R
\name{varImp.SDForest}
\alias{varImp.SDForest}
\alias{varImp}
\title{Extract variable importance of an SDForest}
\usage{
\method{varImp}{SDForest}(object)
}
\arguments{
\item{object}{an SDForest object}
}
\value{
A named vector of variable importance
}
\description{
This function extracts the variable importance of an SDForest.
The variable importance is calculated as the sum of the decrease in the loss function 
resulting from all splits that use a covariate for each tree. 
The mean of the variable importance of all trees results in the variable importance for the forest.
}
\examples{
data(iris)
fit <- SDForest(Sepal.Length ~ Sepal.Width + Petal.Length + Petal.Width, 
                 iris, nTree = 10, cp = 0.5)
varImp(fit)
}
\seealso{
\code{\link{varImp.SDTree}} \code{\link{SDForest}}
}
\author{
Markus Ulmer
}
