% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htcID.R
\name{createHtcIdentifier}
\alias{createHtcIdentifier}
\title{Create an htc identification function.}
\usage{
createHtcIdentifier(idFunc, sources, targets, node, htrSources)
}
\arguments{
\item{idFunc}{identification of edge coefficients often requires that other
edge coefficients already be identified. This argument should be a
function that produces all such identifications. The newly created
identifier function will return these identifications along with its
own.}

\item{sources}{the sources of the half-trek system.}

\item{targets}{the targets of the half-trek system (these should be the
parents of node).}

\item{node}{the node for which all incoming edges are to be identified
(the tails of which are targets).}

\item{htrSources}{the nodes in sources which are half-trek reachable from
node. All incoming edges to these sources should be identified by
idFunc for the newly created identification function to work.}
}
\value{
an identification function
}
\description{
A helper function for \code{\link{htcIdentifyStep}}, creates an identifier
function based on its given parameters. This created identifier function will
identify the directed edges from 'targets' to 'node.'
}
\references{
Foygel, R., Draisma, J., and Drton, M.  (2012) Half-trek criterion for
generic identifiability of linear structural equation models.
\emph{Ann. Statist.} 40(3): 1682-1713.
}
