% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxpro.R
\name{maxproLHD}
\alias{maxproLHD}
\title{Generate a MaxPro Latin-hypercube design}
\usage{
maxproLHD(
  n,
  p,
  design = NULL,
  max.sa.iter = 1e+06,
  temp = 0,
  decay = 0.95,
  no.update.iter.max = 400,
  num.passes = 10,
  max.det.iter = 1e+06,
  method = "full",
  scaled = TRUE
)
}
\arguments{
\item{n}{design size.}

\item{p}{design dimension.}

\item{design}{an initial LHD. If design=NULL, a random LHD is generated.}

\item{max.sa.iter}{maximum number of swapping involved in the simulated annealing (SA) algorithm.}

\item{temp}{initial temperature of the simulated annealing algorithm. If temp=0, it will be automatically determined.}

\item{decay}{the temperature decay rate of simulated annealing.}

\item{no.update.iter.max}{the maximum number of iterations where there is no update to the global optimum before SA stops.}

\item{num.passes}{the maximum number of passes of the whole design matrix if deterministic swapping is used.}

\item{max.det.iter}{maximum number of swapping involved in the deterministic swapping algorithm.}

\item{method}{choice of "deterministic", "sa", or "full". If the method="full", the design is first optimized by SA and then deterministic swapping.}

\item{scaled}{whether the design is scaled to unit hypercube. If scaled=FALSE, the design is represented by integer numbers from 1 to design size. Leave it as TRUE when no initial design is provided.}
}
\value{
\item{design}{final design points.}
\item{total.iter}{total number of swaps in the optimization.}
\item{criterion}{final optimized criterion.}
\item{crit.hist}{criterion history during the optimization process.}
}
\description{
This function generates a MaxPro Latin-hypercube design.
}
\details{
\code{maxproLHD} generates a MaxPro Latin-hypercube design (Joseph, V. R., Gul, E., & Ba, S. 2015). The major difference with the \code{MaxPro} packages is that we have a deterministic swap algorithm, which can be enabled by setting \code{method="deterministic"} or \code{method="full"}. For optimization details, see the detail section in \code{\link{customLHD}}.
}
\examples{
n = 20
p = 3
D = maxproLHD(n, p)

}
\references{
Joseph, V. R., Gul, E., & Ba, S. (2015). Maximum projection designs for computer experiments. Biometrika, 102(2), 371-380.
}
