% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worms_api_functions.R
\name{get_worms_records}
\alias{get_worms_records}
\title{Retrieve WoRMS records}
\usage{
get_worms_records(
  aphia_ids,
  max_retries = 3,
  sleep_time = 10,
  verbose = TRUE,
  aphia_id = deprecated()
)
}
\arguments{
\item{aphia_ids}{A vector of Aphia IDs for which records should be retrieved.}

\item{max_retries}{An integer specifying the maximum number of retry attempts for each Aphia ID in case of failure. Default is 3.}

\item{sleep_time}{A numeric value specifying the time (in seconds) to wait between retry attempts. Default is 10 seconds.}

\item{verbose}{A logical indicating whether to print progress messages. Default is TRUE.}

\item{aphia_id}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Use \code{aphia_ids} instead.}
}
\value{
A \code{tibble} containing the retrieved WoRMS records for the provided Aphia IDs. Each row corresponds to one Aphia ID.
}
\description{
This function retrieves records from the WoRMS (World Register of Marine Species) database using the \code{worrms} R package for a given list of Aphia IDs.
If the retrieval fails, it retries a specified number of times before stopping.
}
\details{
The function attempts to fetch records for each Aphia ID in the provided vector. If a retrieval fails, it retries up to
the specified \code{max_retries}, with a pause of \code{sleep_time} seconds between attempts. If all retries fail for an Aphia ID, the function
stops with an error message.
}
\examples{
\donttest{
# Example usage with a vector of Aphia IDs
aphia_ids <- c(12345, 67890, 112233)
worms_records <- get_worms_records(aphia_ids, verbose = FALSE)

print(worms_records)
}

}
\seealso{
\url{https://marinespecies.org/} for WoRMS website.

\url{https://CRAN.R-project.org/package=worrms}
}
