% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-Colony.R
\docType{class}
\name{Colony-class}
\alias{Colony-class}
\alias{isColony}
\alias{show,Colony-method}
\alias{c,ColonyOrNULL-method}
\title{Honeybee colony}
\usage{
isColony(x)

\S4method{show}{Colony}(object)

\S4method{c}{ColonyOrNULL}(x, ...)
}
\arguments{
\item{x}{\code{\link{Colony-class}}}

\item{object}{\code{\link{Colony-class}}}

\item{...}{\code{NULL}, \code{\link{Colony-class}}, or
\code{\link{MultiColony-class}}}
}
\value{
\code{\link{Colony-class}} or \code{\link{MultiColony-class}}
}
\description{
An object holding honeybee colony
}
\section{Functions}{
\itemize{
\item \code{isColony()}: Test if x is a Colony class object

\item \code{show(Colony)}: Show colony object

\item \code{c(ColonyOrNULL)}: Combine multiple colony objects

}}
\section{Slots}{

\describe{
\item{\code{id}}{integer, unique ID of the colony}

\item{\code{location}}{numeric, location of the colony (x, y)}

\item{\code{queen}}{\code{\link{Pop-class}}, the queen of the colony (we use
its misc slot for queen's age and drones (fathers) she mated with)}

\item{\code{virginQueens}}{\code{\link{Pop-class}}, virgin queens of the
colony}

\item{\code{drones}}{\code{\link{Pop-class}}, drones of the colony}

\item{\code{workers}}{\code{\link{Pop-class}}, workers of the colony}

\item{\code{split}}{logical, has colony split}

\item{\code{swarm}}{logical, has colony swarmed}

\item{\code{supersedure}}{logical, has colony superseded}

\item{\code{collapse}}{logical, has colony collapsed}

\item{\code{production}}{logical, is colony productive}

\item{\code{last_event}}{character, the last event of the colony TODO: revise https://github.com/HighlanderLab/SIMplyBee/issues/10}

\item{\code{misc}}{list, available for storing extra information about the colony}
}}

\examples{
founderGenomes <- quickHaplo(nInd = 4, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1], nInd = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = nFathersPoisson)
colony1 <- createColony(x = basePop[2])
colony1 <- cross(colony1, drones = droneGroups[[1]])
colony2 <- createColony(x = basePop[3])
colony2 <- cross(colony2, drones = droneGroups[[2]])
colony3 <- createColony(x = basePop[4])
colony3 <- cross(colony3, drones = droneGroups[[3]])

colony1
show(colony1)
is(colony1)
isColony(colony1)

apiary <- c(colony1, colony2)
is(apiary)
isMultiColony(apiary)

c(apiary, colony3)
c(colony3, apiary)
}
\seealso{
\code{\link{createColony}}
}
