% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{isCsdHeterozygous}
\alias{isCsdHeterozygous}
\title{Test if individuals are heterozygous at the csd locus}
\usage{
isCsdHeterozygous(pop, simParamBee = NULL)
}
\arguments{
\item{pop}{\code{\link{Pop-class}}}

\item{simParamBee}{\code{\link{SimParamBee}}, global simulation parameters}
}
\value{
logical
}
\description{
Level 0 function that returns if individuals of a population are
  heterozygous at the csd locus. See \code{\link{SimParamBee}} for more
  information about the csd locus.
}
\details{
We could expand \code{isCsdHeterozygous} to work also with
  \code{\link{Colony-class}} and \code{\link{MultiColony-class}} if needed
}
\examples{
founderGenomes <- quickHaplo(nInd = 8, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1], nInd = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = nFathersPoisson)

# Create a Colony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
colony <- buildUp(x = colony, nWorkers = 6, nDrones = 3)
colony <- addVirginQueens(x = colony, nInd = 4)

# Use isCsdHeterozygous on a Population
isCsdHeterozygous(getQueen(colony))
isCsdHeterozygous(getWorkers(colony))
}
