% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_allele_balance.R
\name{filter_allele_balance}
\alias{filter_allele_balance}
\title{Filter out heterozygous genotypes failing an allele balance check}
\usage{
filter_allele_balance(vcfR)
}
\arguments{
\item{vcfR}{a vcfR object}
}
\value{
An identical vcfR object, except that genotypes failing the allele balance
filter have been converted to 'NA'.
}
\description{
This function requires a vcfR object as input, and returns a vcfR object filtered
to convert heterozygous sites with an allele balance falling outside of .25-.75 to 'NA'.
From the \href{https://www.ddocent.com/filtering/}{Ddocent filtering page} "Allele balance:
a number between 0 and 1 representing the ratio of reads showing the reference allele to
all reads, considering only reads from individuals called as heterozygous, we expect that the
allele balance in our data (for real loci) should be close to 0.5".
}
\examples{
filter_allele_balance(vcfR = SNPfiltR::vcfR.example)
}
