% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastphase.R
\name{SNPknock.fp.writeX}
\alias{SNPknock.fp.writeX}
\title{Convert a genetic matrix X into the fastPhase input format.}
\usage{
SNPknock.fp.writeX(X, out_file = NULL)
}
\arguments{
\item{X}{a matrix of size n-by-p containing the original variables.}

\item{out_file}{a string containing the path of the output file onto which X will be written (default: NULL). 
If this is equal to NULL, a temporary file in the R temporary directory will be used.}
}
\value{
A string containing the path of the output file onto which X was written. This is useful to find the data 
when the default option for `out_file` is used and X is written onto a temporary file in the R temporary directory.
}
\description{
This function convert a genetic matrix X into the fastPhase input format and saves
it to a user-specified file. Then, an HMM can be fitted by calling fastPhase with
\link{SNPknock.fp.runFastPhase}.
}
\examples{
# Load an example data matrix X from the package installation directory.
X_file = system.file("extdata", "X.RData", package = "SNPknock")
load(X_file)
Xinp_file = SNPknock.fp.writeX(X) # Write X in a temporary file

}
\references{
Scheet and Stephens,  A fast and flexible statistical model for large-scale population genotype data,
  Am J Hum Genet (2006).
  \href{http://www.sciencedirect.com/science/article/pii/S000292970763701X}{http://www.sciencedirect.com/science/article/pii/S000292970763701X}
}
\seealso{
Other fastphase: \code{\link{SNPknock.fp.loadFit}},
  \code{\link{SNPknock.fp.runFastPhase}}
}
