% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superclasses.R
\name{superClass}
\alias{superClass}
\alias{superClass.somRes}
\alias{print.somSC}
\alias{summary.somSC}
\alias{projectIGraph.somSC}
\alias{plot.somSC}
\alias{somSC-class}
\alias{cutree}
\title{Create Super-Clusters from SOM Results}
\usage{
superClass(sommap, method, members, k, h, ...)

\method{print}{somSC}(x, ...)

\method{summary}{somSC}(object, ...)

\method{plot}{somSC}(
  x,
  what = c("obs", "prototypes", "add"),
  type = c("dendrogram", "grid", "hitmap", "lines", "meanline", "barplot", "boxplot",
    "mds", "color", "poly.dist", "pie", "graph", "dendro3d", "projgraph"),
  plot.var = TRUE,
  show.names = TRUE,
  names = 1:prod(x$som$parameters$the.grid$dim),
  ...
)

\method{projectIGraph}{somSC}(object, init.graph, ...)

cutree(object, k = NULL, h = NULL)
}
\arguments{
\item{sommap}{A \code{somRes} object.}

\item{method}{Argument passed to the \code{\link{hclust}} function.}

\item{members}{Argument passed to the \code{\link{hclust}} function.}

\item{k}{Argument passed to the \code{\link[stats]{cutree}} function (number 
of super-clusters to cut the dendrogram).}

\item{h}{Argument passed to the \code{\link[stats]{cutree}} function (height 
at which to cut the dendrogram).}

\item{\dots}{Used for \code{plot.somSC}: further arguments passed either to
the function \code{\link{plot}} (case \code{type = "dendro"}) or to 
\code{\link{plot.myGrid}} (case \code{type = "grid"}) or to 
\code{\link{plot.somRes}} (all other cases).}

\item{x}{A \code{somSC} object.}

\item{object}{A \code{somSC} object.}

\item{what}{What to plot. Can be either the observations (\code{obs}), the
prototypes (\code{prototypes}), an additional variable (\code{add}), or 
\code{NULL} if not appropriate.\cr
Automatically set for types "hitmap" (to \code{"obs"}) and \code{"grid"}, 
(to \code{"prototypes"}). Default to \code{"obs"} otherwise.\cr
If \code{what = "add"}, the function \code{\link{plot.somRes}} is also run
with the argument \code{what} set to \code{"add"}.}

\item{type}{The type of plot to draw. Default value is \code{"dendrogram"}, 
to plot the dendrogram of the clustering. Case \code{"grid"} plots the grid 
with colors corresponding to the clusters of the super clustering. Case
\code{"projgraph"} uses an \link[igraph]{is_igraph} object passed to the 
argument \code{variable} and plots the projected graph as defined by the 
method \code{projectIGraph}. All other cases are those available in the 
function \code{\link{plot.somRes}} and superimpose the super-clusters over 
these plots.}

\item{plot.var}{A boolean indicating whether a plot showing the evolution of
the explained variance should be plotted. This argument is only used when 
\code{type = "dendrogram"}, its default value is \code{TRUE}.}

\item{show.names}{Whether the cluster titles must be printed in center of
the grid or not for \code{type = "grid"}. Default to \code{FALSE} (titles not 
displayed).}

\item{names}{If \code{show.names = TRUE}, values of the title to 
display for \code{type="grid"}. Default to "Cluster " followed by the cluster
number.}

\item{init.graph}{An \link[igraph]{igraph} object which is projected 
according to the super-clusters. The vertices of \code{init.graph} must
correspond to the rows of the original dataset processed by SOM (note that 
case \code{"korresp"} is not handled by this function). In the projected
graph, the vertices are positioned at the center of gravity of the 
super-clusters (more details in the section \strong{Details} below).}
}
\value{
The \code{superClass} method returns an object of class \code{somSC},
which is a list of the following elements: 
  \item{cluster}{The super clustering of the prototypes (only if either 
  \code{k} or \code{h} are given by user).}
  \item{tree}{An \code{\link{hclust}} object.}
  \item{som}{The \code{somRes} object given as argument (see 
  \code{\link{trainSOM}} for details).}
  
The \code{projectIGraph} method returns an object of class 
\code{\link[igraph]{is_igraph}} with the following attributes: 
  \item{\code{layout}}{ provides the layout of the projected graph 
  according to the center of gravity of the super-clusters positioned on 
  the SOM grid (graph attribute);}
  \item{\code{name} and \code{size}}{ respectively are the vertex number on 
  the grid and the number of vertexes included in the corresponding cluster 
  (vertex attribute);}
  \item{\code{weight}}{ gives the number of edges (or the sum of the weights)
   between the vertexes of the two corresponding clusters (edge attribute).}
}
\description{
Aggregate the resulting clustering of the SOM algorithm into 
super-clusters.
}
\details{
The \code{superClass} method can be used in 2 ways: \itemize{
  \item to choose the number of super clusters via an \code{\link{hclust}} 
  object: then, both arguments \code{k} and \code{h} can be \code{NULL}. In
  this case, \code{superClass} only returns the dendrogram of the 
  hierarchical clustering, which can then be cut with the method 
  \code{cutree} (to which either \code{k} or \code{h} must be specified);
  \item to cut the clustering into super clusters. Then, either argument 
  \code{k} or argument \code{h} must be specified (see 
  \code{\link[stats]{cutree}} for details).
}
  
The squared distance between prototypes is passed to the algorithm.

\code{summary} on a \code{superClass} object produces a complete summary of 
the results that displays the number of clusters and super-clusters, the 
clustering itself and performs ANOVA analyses. For \code{type = "numeric"} 
the ANOVA is performed for each input variable and test the difference of 
this variable across the super-clusters of the map. For 
\code{type = "relational"} a dissimilarity ANOVA is performed (see 
(Anderson, 2001), except that in the present version, a crude estimate of the 
p-value is used which is based on the Fisher distribution and not on a 
permutation test.

On plots, the different super classes are identified in the following ways:
\itemize{ 
  \item either with different color, when \code{type} is set among: 
  \code{"grid"} (N, K, R), \code{"hitmap"} (N, K, R), \code{"lines"} 
  (N, K, R), \code{"barplot"} (N, K, R), \code{"boxplot"}, \code{"poly.dist"}
  (N, K, R), \code{"mds"} (N, K, R), \code{"dendro3d"} (N, K, R), 
  \code{"graph"} (R), \code{"projgraph"} (R);
  \item or with title, when \code{type} is set among: \code{"color"} (N, K),
  \code{"pie"} (N, R).
}

In the list above, the charts available for a \code{numerical} SOM are 
indicated with a N, with a K for a \code{korresp} SOM and with an R for 
\code{relational} SOM.

\code{projectIGraph} produces a projected graph from the 
\link[igraph]{is_igraph} object passed to the argument \code{variable} as 
described in (Olteanu and Villa-Vialaneix, 2015). The attributes of this 
graph are the same than the ones obtained from the SOM map itself in the 
function \code{projectIGraph}. \code{\link{plot.somSC}} used with
\code{type = "projgraph"} calculates this graph and represents it by 
positioning the super-vertexes at the center of gravity of the 
super-clusters. This feature can be combined with \code{pie.graph = TRUE} to 
super-impose the information from an external factor related to the 
individuals in the original dataset (or, equivalently, to the vertexes of the
graph).
}
\examples{
set.seed(11051729)
my.som <- trainSOM(x.data = iris[,1:4])
# choose the number of super-clusters
sc <- superClass(my.som)
plot(sc)
# cut the clustering
sc <- superClass(my.som, k = 4)
summary(sc)
plot(sc)
plot(sc, type = "grid")
plot(sc, what = "obs", type = "hitmap")

# cut the clustering with a different number of clusters
sc <- superClass(my.som, k = 5)
summary(sc)
}
\references{
Anderson M.J. (2001). A new method for non-parametric multivariate analysis 
of variance. \emph{Austral Ecology}, \strong{26}, 32-46.

Olteanu M., Villa-Vialaneix N. (2015) Using SOMbrero for clustering and 
visualizing graphs. \emph{Journal de la Societe Francaise de Statistique}, 
\strong{156}, 95-119.
}
\seealso{
\code{\link{hclust}}, \code{\link[stats]{cutree}}, 
\code{\link{trainSOM}}, \code{\link{plot.somRes}}
}
\author{
Élise Maigné \email{elise.maigne@inrae.fr}\cr
Madalina Olteanu \email{olteanu@ceremade.dauphine.fr}\cr
Nathalie Vialaneix \email{nathalie.vialaneix@inrae.fr}
}
