% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ext_bindings.R
\name{SQM_to_microeco}
\alias{SQM_to_microeco}
\title{Convert a SQM object into a microtable object from the \emph{microeco} package}
\usage{
SQM_to_microeco(
  SQM,
  features = "genus",
  count = "abund",
  md = NULL,
  nocds = "treat_separately",
  no_partial_classifications = FALSE,
  ignore_unclassified = FALSE,
  ignore_unmapped = FALSE,
  bin_tax_source = "SQM",
  include_seqs = FALSE
)
}
\arguments{
\item{SQM}{A SQM, SQMbunch or SQMlite object.}

\item{features}{character. Either \code{"orfs"}, \code{"contigs"}, \code{"bins"}, any taxonomic rank included in \code{SQM$taxa} or any functional classication included in \code{SQM$functions} (default \code{"tax"}). Note that a given feature type might not be available in this objects (e.g. \code{"contigs"} in SQMlite objects originating from a SQM reads project).}

\item{count}{character. Either \code{"abund"} for raw abundances, \code{"percent"} for percentages, \code{"bases"} for raw base counts, \code{"cov"} for coverages, \code{"cpm"} for coverages per million reads, \code{"tpm"} for TPM normalized values or \code{"copy_number"} for copy numbers (default \code{"abund"}). Note that a given count type might not available in this object (e.g. TPM or copy number in SQMlite objects originating from a SQM reads project).}

\item{md}{data.frame. A optional data.frame containing metadata for the samples in the SQM object.}

\item{nocds}{character. Either \code{"treat_separately"} to treat features annotated as No CDS separately, \code{"treat_as_unclassified"} to treat them as Unclassified or \code{"ignore"} to ignore them in the output (default \code{"treat_separately"}).}

\item{no_partial_classifications}{logical. When \code{features} is a taxonomic rank, treat features not fully classified at the requested level (e.g. "Unclassified bacteroidota" at the class level or below) as fully unclassified. This takes effect before \code{ignore_unclassified}, so if both are \code{TRUE} the plot will only contain features that were fully classified at the requested level (default \code{FALSE}).}

\item{ignore_unclassified}{logical. When \code{features} is a taxonomic rank or functional category, don't include unclassified reads in the output (default \code{FALSE}).}

\item{ignore_unmapped}{logical. Don't include unmapped reads in the output (default \code{FALSE}).}

\item{bin_tax_source}{character. Source of taxonomy when \code{features = "bins"}, either \code{"SQM"} of \code{"gtdb"} (default  \code{"gtdb"}).}

\item{include_seqs}{logical. Whether to include sequences or not if creating a microtable from contigs (default \code{FALSE}).}
}
\value{
A \code{\link[microeco]{microtable}}.
}
\description{
This function will convert the selected features from a SQM object into an object of the \code{\link[microeco]{microtable}} class from the \href{https://chiliubio.github.io/microeco/}{microeco} package. When possible, it will also include the taxonomy of the included features (for functional classifications, the taxonomy table will instead include the description of each feature ID). Optionally, it accepts a meta table that will be passed as provided to \code{microtable$new}.
}
\seealso{
\code{\link{SQM_to_phyloseq}} for exporting a SQM/SQMlite/SQM object as a phyloseq object.
}
