% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{srt.shift}
\alias{srt.shift}
\title{Re-synchronize Srt File}
\usage{
srt.shift(srt, time_shifted)
}
\arguments{
\item{srt}{vector. The srt file read by \code{\link[SRTtools]{srt.read}}.}

\item{time_shifted}{numeric. The time that srt file want to be shifted (in seconds).}
}
\description{
Shift a srt file with specific time.
}
\examples{
srt_path <- system.file("extdata", "movie.srt", package="SRTtools")
srt <- srt.read(srt_path, encoding = 'utf-8')

# Postpone subtitles 3 seconds later
srt <- srt.shift(srt, time_shifted = 3)

# Expedite subtitles 5 seconds earlier
srt <- srt.shift(srt, time_shifted = -5)

}
\seealso{
\code{\link[SRTtools]{srt.read}}
}
