% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{srt.insert}
\alias{srt.insert}
\title{Insert new dialog}
\usage{
srt.insert(srt, index, time, text)
}
\arguments{
\item{srt}{vector. The srt file read by \code{\link[SRTtools]{srt.read}}.}

\item{index}{integer. The index of new dialog.}

\item{time}{character. The time of new dialog, a proper format is "hr:min:sec,msec --> hr:min:sec,msec"}

\item{text}{character. The content of new dialog.}
}
\description{
Insert new dialog to subtitles by specific index
}
\examples{
srt_path <- system.file("extdata", "movie.srt", package="SRTtools")
srt <- srt.read(srt_path, encoding = 'utf-8')
srt.insert(srt, index = 1, time = "00:00:00,000 --> 00:00:30,000", text = "Added by SRTtools")

}
\seealso{
\code{\link[SRTtools]{srt.read}}
}
