% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FormulaSelection.R
\name{FormulaSelection}
\alias{FormulaSelection}
\title{Limit matrix or data frame to selected model terms}
\usage{
FormulaSelection(x, formula)
}
\arguments{
\item{x}{Model matrix or a data frame}

\item{formula}{Formula representing the limitation}
}
\value{
Limited model matrix or a data frame
}
\description{
For use with output from \code{\link{ModelMatrix}} or data frames derived from such output.
}
\details{
The selection is based on \code{startCol} or \code{startRow} attribute in input \code{x}.
}
\examples{
z <- SSBtoolsData("sprt_emp_withEU")
z$age[z$age == "Y15-29"] <- "young"
z$age[z$age == "Y30-64"] <- "old"

x <- ModelMatrix(z, formula = ~age * year)

FormulaSelection(x, ~age)
FormulaSelection(x, ~year)
FormulaSelection(x, ~year:age)


a <- ModelMatrix(z, formula = ~age * geo + year, crossTable = TRUE)
b <- cbind(as.data.frame(a$crossTable), 
           sum = (t(a$modelMatrix) \%*\% z$ths_per)[, 1], 
           max = DummyApply(a$modelMatrix, 
           z$ths_per, max))
rownames(b) <- NULL
attr(b, "startRow") <- attr(a$modelMatrix, "startCol", exact = TRUE)

FormulaSelection(b, ~geo * age)
FormulaSelection(b, ~age:geo)
FormulaSelection(b, ~year)
}
