% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_data}
\alias{get_data}
\title{Download data from SUNGEO server}
\usage{
get_data(
  country_names = NULL,
  country_iso3 = NULL,
  geoset = "geoBoundaries",
  geoset_yr = 2020,
  space_unit = "adm1",
  time_unit = "year",
  topics = NULL,
  year_min = 1990,
  year_max = 2017,
  print_url = TRUE,
  print_time = TRUE,
  error_stop = FALSE,
  by_topic = TRUE,
  skip_missing = TRUE,
  cache_param = FALSE,
  short_message = TRUE
)
}
\arguments{
\item{country_names}{Country name(s). Character string (single country) or vector of character strings (multiple countries).}

\item{country_iso3}{Country code (ISO 3166-1 alpha-3). Character string (single country) or vector of character strings (multiple countries).}

\item{geoset}{Name of geographic boundary set. Can be one of \code{"GADM"} (Database of Global Administrative Areas), \code{"GAUL"} (Global Administrative Unit Layers), \code{"geoBoundaries"}, \code{"GRED"} (GeoReferenced Electoral Districts Datasets), \code{"HEXGRID"} (SUNGEO Hexagonal Grid), \code{"MPIDR"} (Max Planck Institute for Demographic Research Population History GIS Collection), \code{"NHGIS"} (National Historical Geographic Information System), \code{"PRIOGRID"} (PRIO-GRID 2.0), \code{"SHGIS"} (SUNGEO Historical GIS). Default is \code{"geoBoundaries"}. Character string.}

\item{geoset_yr}{Year of geographic boundaries. See \code{get_info()['geosets']} for availability. Default is \code{2020}. Integer.}

\item{space_unit}{Geographic level of analysis. Can be one of \code{"adm0"} (country), \code{"adm1"} (province), \code{"adm2"} (district), \code{"cst"} (GRED electoral constituency), \code{"hex05"} (SUNGEO Hexagonal Grid cell), \code{"prio"} (PRIO-GRID cell). See \code{get_info()['geosets']} for availability by geoset, country and topic. Default is \code{"adm1"}. Character string.}

\item{time_unit}{Temporal level of analysis. Can be one of \code{"year"}, \code{"month"}, \code{"week"}. See \code{get_info()['topics']} for availability by topic. Default is \code{"year"}. Character string.}

\item{topics}{Data topics. See \code{get_info()['summary']} for full list. Character string (single topic) or vector of character strings (multiple topics).}

\item{year_min}{Time range of requested data: start year. See \code{get_info()['topics']} for availability by topic. Default is \code{1990}. Integer.}

\item{year_max}{Time range of requested data: end year. See \code{get_info()['topics']} for availability by topic. Default is \code{2017}. Integer.}

\item{print_url}{Print url string of requested data to console? Default is \code{TRUE}. Logical.}

\item{print_time}{Print processing time for API query to console? Default is \code{TRUE}. Logical.}

\item{error_stop}{Error handling. If \code{TRUE}, function terminates request if an error is encountered. If \code{FALSE}, error is skipped and error message is recorded in a new \code{message} column. Default is \code{FALSE}. Logical.}

\item{by_topic}{Break query down by topic and country? If \code{TRUE}, a separate request is sent to the API for each country and topic, and the results are combined on the client side. This ensures that data that are available for some, but not all countries are returned, rather than resulting in a failed request. If \code{FALSE}, a single request is sent to the API for all countries and topics, and the results are combined on the server side. Only data that are available for all countries are returned. Default is \code{TRUE}. Logical.}

\item{skip_missing}{Skip missing data topics? If \code{TRUE}, missing data topics are skipped, columns are populated with NAs, and corresponding error message is recorded in a new \code{message} column. If \code{FALSE}, returns NULL results for missing topics. Default is \code{TRUE}. Logical.}

\item{cache_param}{Store cached query on server? This can speed up processing for repeated queries. Default is \code{FALSE}. Logical.}

\item{short_message}{Shorten error messages? If \code{TRUE}, a short, informative error message is recorded in the \code{message} column. If \code{FALSE}, full error message is recorded. Default is \code{TRUE}. Logical.}
}
\value{
data.table object, with requested data from SUNGEO API.
}
\description{
Function to download data files through the SUNGEO API. Function produces a data.table object, corresponding to the user's choice of countries, topics, sources, and spatial and temporal units.
}
\examples{
# Single country, single topic
\dontrun{
out_1 <- get_data(country_name="Afghanistan",topics="Demographics:Population:GHS")
out_1
}

\dontrun{
out_2 <- get_data(
	country_name=c("Afghanistan","Moldova"),
	topics=c("Demographics:Ethnicity:EPR","Demographics:Population:GHS"))
out_2
}

# Other boundary sets, spatial and time units
\dontrun{
out_3 <- get_data(
	country_name="Albania",
	topics="Weather:AirTemperatureAndPrecipitation:NOAA",
	geoset="GAUL",geoset_yr=1990,space_unit="adm2",time_unit="month",
	year_min=1990,year_max=1991)
out_3
}
}
\seealso{
\code{\link{get_info}}
}
