% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\name{svem_nonzero}
\alias{svem_nonzero}
\title{Coefficient Nonzero Percentages (SVEM)}
\usage{
svem_nonzero(object, tol = 1e-07, plot = TRUE, print_table = TRUE, ...)
}
\arguments{
\item{object}{An object of class \code{svem_model}.}

\item{tol}{Numeric tolerance for "nonzero" (default \code{1e-7}).}

\item{plot}{Logical; if \code{TRUE}, draws a quick ggplot summary (default \code{TRUE}).}

\item{print_table}{Logical; if \code{TRUE}, prints a compact table (default \code{TRUE}).}

\item{...}{Unused.}
}
\value{
Invisibly returns a data frame with columns:
\itemize{
\item \code{Variable}
\item \code{Percent of Bootstraps Nonzero}
}
}
\description{
Calculates the percentage of bootstrap iterations in which each coefficient
(excluding the intercept) is nonzero, using a small tolerance. Optionally
draws a quick \pkg{ggplot2} summary and/or prints a compact table.
}
\details{
This function summarizes variable selection stability across SVEM bootstrap
refits. It expects \code{object$coef_matrix} to contain the per-bootstrap
coefficients (including an intercept column).
}
\examples{
\donttest{
  ## ---------- Gaussian demo ----------
  set.seed(10)
  n  <- 220
  x1 <- rnorm(n)
  x2 <- rnorm(n)
  x3 <- rnorm(n)
  eps <- rnorm(n, sd = 0.4)
  y   <- 0.7 + 1.5*x1 - 0.8*x2 + 0.05*x3 + eps
  dat <- data.frame(y, x1, x2, x3)

  fit <- SVEMnet(y ~ (x1 + x2 + x3)^2, data = dat, nBoot = 40, relaxed = TRUE)

  # Table + plot
  nz <- svem_nonzero(fit, tol = 1e-7, plot = TRUE, print_table = TRUE)
  head(nz)

  ## ---------- Binomial demo ----------
  set.seed(11)
  n  <- 260
  x1 <- rnorm(n)
  x2 <- rnorm(n)
  x3 <- rnorm(n)
  lp <- -0.3 + 0.9*x1 - 0.6*x2 + 0.2*x3
  p  <- 1/(1+exp(-lp))
  y  <- rbinom(n, 1, p)
  dat_b <- data.frame(y, x1, x2, x3)

  fit_b <- SVEMnet(y ~ x1 + x2 + x3, data = dat_b,
                   family = "binomial", nBoot = 40, relaxed = TRUE)

  # Plot optional; still summarizes the bootstrap selection frequencies
  svem_nonzero(fit_b, plot = TRUE, print_table = TRUE)
}

}
\seealso{
\code{\link[=coef.svem_model]{coef.svem_model}} for averaged (optionally debiased) coefficients.
}
