% Generated by roxygen2 (4.0.2): do not edit by hand
\encoding{UTF-8}
\name{normalize}
\alias{normalize}
\alias{normalize.character}
\alias{normalize.default}
\alias{normalize.factor}
\alias{normalize.numeric}
\title{Unity-based normalization}
\usage{
normalize(x, range, domain, ...)

\method{normalize}{factor}(x, range, domain = range(1:nlevels(x)), ...)

\method{normalize}{numeric}(x, range = c(0, 1), domain = range(x, na.rm =
  TRUE), ...)

\method{normalize}{default}(x, range = c(0, 1), domain, ...)

\method{normalize}{character}(x, range = c(0, 1), domain, ...)
}
\arguments{
\item{x}{is a vector to be normalized.}

\item{range}{is a numeric vector of length 2 for min and max values, default is \code{c(0,1)}.}

\item{domain}{a numeric vector of length 2.}

\item{\dots}{further arguments passed to or used by other methods.}
}
\value{
Normalized values in an object of the same class as \code{var}.
}
\description{
Normalizes as feature scaling, \code{min - max}, or unity-based normalization. Typically used to bring all values into the range [0,1]. However, this can be generalized to restrict the range of values in the dataset between any arbitrary points  \code{a}  and  \code{b}, using: \deqn{X' = a + \frac{(x - x_{min})(b - a)}{(x_{max} - x_{min})}}.
}
\examples{
x <- sample(10)
normalize(x, range=c(0,1))
normalize(x)
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}
}
\seealso{
svTransform

\code{\link{scale}}, \code{\link{unscale}}
}
\keyword{Normalization}
\keyword{Rescaling}

