% Generated by roxygen2 (4.0.2): do not edit by hand
\encoding{UTF-8}
\name{orrr}
\alias{oddsRatio}
\alias{orrr}
\alias{print.oddsRatio}
\alias{print.relrisk}
\alias{relrisk}
\alias{summary.oddsRatio}
\alias{summary.relrisk}
\title{Odds Ratio and Relative Risk for 2 x 2 Contingency Tables}
\usage{
orrr(x, conf.level = 0.95, verbose = TRUE, digits = 3, relrisk = FALSE)

oddsRatio(x, conf.level = 0.95, verbose = TRUE, digits = 3)

relrisk(x, conf.level = 0.95, verbose = TRUE, digits = 3)

\method{print}{oddsRatio}(x, digits = 3, ...)

\method{print}{relrisk}(x, digits = 3, ...)

\method{summary}{oddsRatio}(object, digits = 3, ...)

\method{summary}{relrisk}(object, digits = 3, ...)
}
\arguments{
\item{x}{a 2 X 2 matrix, data frame or table of counts}

\item{conf.level}{the confidence interval level}

\item{verbose}{a logical indicating whether verbose output should be displayed}

\item{digits}{number of digits to display}

\item{relrisk}{a logical indicating whether the relative risk should be returned
instead of the odds ratio}

\item{object}{an R object to print or summarise.  Here an object of class
\code{"oddsRatio"} or \code{"relrisk"}.}

\item{\dots}{further arguments passed to or used by other methods.}
}
\value{
an odds ratio or relative risk.  If \code{verpose=TRUE},
more details and the confidence intervals are displayed.
}
\description{
Calculates odds ratios, relative risk, and confidence intervals on odds ratios.
}
\details{
\code{x} should be a matrix, data frame or table. \dQuote{Successes}
should be located in column 1 of \code{x}, and the treatment of interest
should be located in row 2. The odds ratio is calculated as \deqn{(Odds row 2)/(Odds row 1)}.
The confidence interval is calculated from the \code{log(OR)} and back transformed.
}
\examples{
mat <- matrix(c(100, 100, 100, 100), nrow = 2)
mat
oddsRatio(mat)

mat2 <- matrix(c(18515, 18496, 1427, 1438), nrow = 2)
rownames(mat2) <- c("Placebo", "Aspirin")
colnames(mat2) <- c("No", "Yes")
mat2
oddsRatio(mat2)
oddsRatio(mat2, verbose=FALSE)
relrisk(mat2, verbose=FALSE)
# example 2
out <- matrix(c(131,75,27, 6), nrow=2)
 rownames(out) <- c("No disease", "Have disease")
 colnames(out) <- c("<40\%", ">40\%")
 oddsRatio(out)
}
\author{
Kevin Middleton (\email{kmm@csusb.edu}); modified by Daniel Marcelino.
}
\keyword{stats}

