% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bar.plot.R
\name{bar.plot}
\alias{bar.plot}
\title{Plot a barplot with ggplot2}
\usage{
bar.plot(data, xvar = NULL, yvar = NULL, group.var = NULL,
  group.colors = NULL, palette = NULL, stat = "identity", ...)
}
\arguments{
\item{data}{The data frame.}

\item{xvar}{The name of column containing x variable. Default value is NULL.}

\item{yvar}{The name of column containing y variable.}

\item{group.var}{The name of column containing group variable. This variable is used to color plot according to the group.}

\item{group.colors}{The color of groups; group.colors should have the same length as groups.}

\item{palette}{This can be also used to indicate group colors. In this case the parameter group.colors should be NULL.}

\item{stat}{The statistical transformation to use on the data for this layer; default value is \code{identity}. To get a bar graph of counts, don't map a variable to y, and use \code{stat="bin"}}

\item{\dots}{Other parameters passed on to ggplot2.customize function.}
}
\description{
Plot a barplot with ggplot2
}
\examples{
if (interactive()) {
x = sample(10, 100, rep = TRUE)
y = stats::rnorm(100)
z = sample(letters[1:3],100, rep=TRUE)
dat = data.frame(x,y,z)

bar.plot(dat, 'x', 'y')
bar.plot(dat, 'x', 'y', group.var = 'z')
}
}

