% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/TESTS.R
\encoding{UTF-8}
\name{jensen.shannon}
\alias{jensen.shannon}
\title{Jensen-Shannon Distance}
\usage{
jensen.shannon(mat)
}
\arguments{
\item{mat}{An n x p matrix.}
}
\description{
The Jensen-Shannon divergence or distance matrix stores the \eqn{n*(n-1)/2} pairwise distances/similarities between observations in an \eqn{n x p} matrix where n correspond to the independent observational units and p represent the covariates measured on each individual.
}
\examples{
# create a matrix
n  = 10
m = matrix(runif(n*10), ncol = 10)
m = m/rowSums(m)

jensen.shannon(m)
}
\keyword{Tests}

