% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction.R
\name{SubsetData}
\alias{SubsetData}
\title{Return a subset of the Seurat object}
\usage{
SubsetData(object, cells.use = NULL, subset.name = NULL, ident.use = NULL,
  ident.remove = NULL, accept.low = -Inf, accept.high = Inf,
  do.center = FALSE, do.scale = FALSE, max.cells.per.ident = Inf,
  random.seed = 1, ...)
}
\arguments{
\item{object}{Seurat object}

\item{cells.use}{A vector of cell names to use as a subset. If NULL
(default), then this list will be computed based on the next three
arguments. Otherwise, will return an object consissting only of these cells}

\item{subset.name}{Parameter to subset on. Eg, the name of a gene, PC1, a
column name in object@meta.data, etc. Any argument that can be retreived
using FetchData}

\item{ident.use}{Create a cell subset based on the provided identity classes}

\item{ident.remove}{Subtract out cells from these identity classes (used for filtration)}

\item{accept.low}{Low cutoff for the parameter (default is -Inf)}

\item{accept.high}{High cutoff for the parameter (default is Inf)}

\item{do.center}{Recenter the new object@scale.data}

\item{do.scale}{Rescale the new object@scale.data. FALSE by default}

\item{max.cells.per.ident}{Can be used to downsample the data to a certain max per cell ident. Default is inf.}

\item{random.seed}{Random seed for downsampling}

\item{\dots}{Additional arguments to be passed to FetchData (for example,
use.imputed=TRUE)}
}
\value{
Returns a Seurat object containing only the relevant subset of cells
}
\description{
Creates a Seurat object containing only a subset of the cells in the
original object. Takes either a list of cells to use as a subset, or a
parameter (for example, a gene), to subset on.
}
\examples{
pbmc1 <- SubsetData(object = pbmc_small, cells.use = pbmc_small@cell.names[1:40])
pbmc1

}
