% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{VariableGenePlot}
\alias{VariableGenePlot}
\title{View variable genes}
\usage{
VariableGenePlot(object, do.text = TRUE, cex.use = 0.5,
  cex.text.use = 0.5, do.spike = FALSE, pch.use = 16, col.use = "black",
  spike.col.use = "red", plot.both = FALSE, do.contour = TRUE,
  contour.lwd = 3, contour.col = "white", contour.lty = 2,
  x.low.cutoff = 0.1, x.high.cutoff = 8, y.cutoff = 1,
  y.high.cutoff = Inf)
}
\arguments{
\item{object}{Seurat object}

\item{do.text}{Add text names of variable genes to plot (default is TRUE)}

\item{cex.use}{Point size}

\item{cex.text.use}{Text size}

\item{do.spike}{FALSE by default. If TRUE, color all genes starting with ^ERCC a different color}

\item{pch.use}{Pch value for points}

\item{col.use}{Color to use}

\item{spike.col.use}{if do.spike, color for spike-in genes}

\item{plot.both}{Plot both the scaled and non-scaled graphs.}

\item{do.contour}{Draw contour lines calculated based on all genes}

\item{contour.lwd}{Contour line width}

\item{contour.col}{Contour line color}

\item{contour.lty}{Contour line type}

\item{x.low.cutoff}{Bottom cutoff on x-axis for identifying variable genes}

\item{x.high.cutoff}{Top cutoff on x-axis for identifying variable genes}

\item{y.cutoff}{Bottom cutoff on y-axis for identifying variable genes}

\item{y.high.cutoff}{Top cutoff on y-axis for identifying variable genes}
}
\description{
View variable genes
}
\examples{
VariableGenePlot(object = pbmc_small)

}
