% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printing_utilities.R
\name{PrintCCAParams}
\alias{PrintCCAParams}
\title{Print CCA Calculation Parameters}
\usage{
PrintCCAParams(object, raw = FALSE)
}
\arguments{
\item{object}{Seurat object}

\item{raw}{Print the entire contents of the calculation settings slot
(calc.params) for the RunCCA calculation. Default (FALSE) will print a nicely
formatted summary.}
}
\value{
No return value. Only prints to console.
}
\description{
Print the parameters chosen for the latest stored CCA calculation.
}
\examples{
# As CCA requires two datasets, we will split our test object into two just for this example
pbmc1 <- SubsetData(pbmc_small,cells.use = pbmc_small@cell.names[1:40])
pbmc2 <- SubsetData(pbmc_small,cells.use = pbmc_small@cell.names[41:80])
pbmc1@meta.data$group <- "group1"
pbmc2@meta.data$group <- "group2"
pbmc_cca <- RunCCA(pbmc1,pbmc2)
PrintCCAParams(object = pbmc_cca)

}
