% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensional_reduction.R
\name{RunTSNE}
\alias{RunTSNE}
\title{Run t-distributed Stochastic Neighbor Embedding}
\usage{
RunTSNE(object, reduction.use = "pca", cells.use = NULL, dims.use = 1:5,
  genes.use = NULL, seed.use = 1, do.fast = TRUE, add.iter = 0,
  dim.embed = 2, distance.matrix = NULL, reduction.name = "tsne",
  reduction.key = "tSNE_", ...)
}
\arguments{
\item{object}{Seurat object}

\item{reduction.use}{Which dimensional reduction (e.g. PCA, ICA) to use for
the tSNE. Default is PCA}

\item{cells.use}{Which cells to analyze (default, all cells)}

\item{dims.use}{Which dimensions to use as input features}

\item{genes.use}{If set, run the tSNE on this subset of genes
(instead of running on a set of reduced dimensions). Not set (NULL) by default}

\item{seed.use}{Random seed for the t-SNE}

\item{do.fast}{If TRUE, uses the Barnes-hut implementation, which runs
faster, but is less flexible. TRUE by default.}

\item{add.iter}{If an existing tSNE has already been computed, uses the
current tSNE to seed the algorithm and then adds additional iterations on top
of this}

\item{dim.embed}{The dimensional space of the resulting tSNE embedding
(default is 2). For example, set to 3 for a 3d tSNE}

\item{distance.matrix}{If set, runs tSNE on the given distance matrix
instead of data matrix (experimental)}

\item{reduction.name}{dimensional reduction name, specifies the position in the object$dr list. tsne by default}

\item{reduction.key}{dimensional reduction key, specifies the string before the number for the dimension names. tSNE_ by default}

\item{\dots}{Additional arguments to the tSNE call. Most commonly used is
perplexity (expected number of neighbors default is 30)}
}
\value{
Returns a Seurat object with a tSNE embedding in
object@dr$tsne@cell.embeddings
}
\description{
Run t-SNE dimensionality reduction on selected features. Has the option of
running in a reduced dimensional space (i.e. spectral tSNE, recommended),
or running based on a set of genes. For details about stored TSNE calculation
parameters, see \code{PrintTSNEParams}.
}
\examples{
pbmc_small
# Run tSNE on first five PCs, note that for test dataset (only 80 cells)
# we can't use default perplexity of 30
pbmc_small <- RunTSNE(pbmc_small, reduction.use = "pca", dims.use = 1:5, perplexity=10)
# Run tSNE on first five independent components from ICA
pbmc_small <- RunICA(pbmc_small,ics.compute=5)
pbmc_small <- RunTSNE(pbmc_small, reduction.use = "ica", dims.use = 1:5, perplexity=10)
# Plot results
TSNEPlot(pbmc_small)

}
