% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_modal.R
\name{HTODemux}
\alias{HTODemux}
\title{Demultiplex samples based on data from cell 'hashing'}
\usage{
HTODemux(object, assay.type = "HTO", positive_quantile = 0.99,
  init_centers = NULL, cluster_nstarts = 100, k_function = "clara",
  nsamples = 100, print.output = TRUE)
}
\arguments{
\item{object}{Seurat object. Assumes that the hash tag oligo (HTO) data has been added and normalized.}

\item{assay.type}{Name of the Hashtag assay (HTO by default)}

\item{positive_quantile}{The quantile of inferred 'negative' distribution for each hashtag - over which the cell is considered 'positive'. Default is 0.99}

\item{init_centers}{Initial number of clusters for hashtags. Default is the # of hashtag oligo names + 1 (to account for negatives)}

\item{cluster_nstarts}{nstarts value for k-means clustering (for k_function = "kmeans"). 100 by default}

\item{k_function}{Clustering function for initial hashtag grouping. Default is "clara" for fast k-medoids clustering on large applications, also support "kmeans" for kmeans clustering}

\item{nsamples}{Number of samples to be drawn from the dataset used for clustering, for k_function = "clara"}

\item{print.output}{Prints the output}
}
\value{
The Seurat object with the following demultiplexed information stored in the meta data:
\item{hash_maxID}{Name of hashtag with the highest signal}
\item{hash_secondID}{Name of hashtag with the second highest signal}
\item{hash_margin}{The difference between signals for hash_maxID and hash_secondID}
\item{hto_classification}{Classification result, with doublets/multiplets named by the top two highest hashtags}
\item{hto_classification_global}{Global classification result (singlet, doublet or negative)}
\item{hash_ID}{Classification result where doublet IDs are collapsed}
}
\description{
Assign sample-of-origin for each cell, annotate doublets.
}
\examples{
\dontrun{
object <- HTODemux(object)
}
}
