% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{RidgePlot}
\alias{RidgePlot}
\title{Single cell ridge plot}
\usage{
RidgePlot(object, features.plot, ident.include = NULL, nCol = NULL,
  do.sort = FALSE, y.max = NULL, same.y.lims = FALSE, size.x.use = 16,
  size.y.use = 16, size.title.use = 20, cols.use = NULL,
  group.by = NULL, y.log = FALSE, x.lab.rot = FALSE, y.lab.rot = FALSE,
  legend.position = "right", single.legend = TRUE, remove.legend = FALSE,
  do.return = FALSE, return.plotlist = FALSE, ...)
}
\arguments{
\item{object}{Seurat object}

\item{features.plot}{Features to plot (gene expression, metrics, PC scores,
anything that can be retreived by FetchData)}

\item{ident.include}{Which classes to include in the plot (default is all)}

\item{nCol}{Number of columns if multiple plots are displayed}

\item{do.sort}{Sort identity classes (on the x-axis) by the average
expression of the attribute being potted}

\item{y.max}{Maximum y axis value}

\item{same.y.lims}{Set all the y-axis limits to the same values}

\item{size.x.use}{X axis title font size}

\item{size.y.use}{Y axis title font size}

\item{size.title.use}{Main title font size}

\item{cols.use}{Colors to use for plotting}

\item{group.by}{Group (color) cells in different ways (for example, orig.ident)}

\item{y.log}{plot Y axis on log scale}

\item{x.lab.rot}{Rotate x-axis labels}

\item{y.lab.rot}{Rotate y-axis labels}

\item{legend.position}{Position the legend for the plot}

\item{single.legend}{Consolidate legend the legend for all plots}

\item{remove.legend}{Remove the legend from the plot}

\item{do.return}{Return a ggplot2 object (default : FALSE)}

\item{return.plotlist}{Return the list of individual plots instead of compiled plot.}

\item{\dots}{additional parameters to pass to FetchData (for example, use.imputed, use.scaled, use.raw)}
}
\value{
By default, no return, only graphical output. If do.return=TRUE,
returns a list of ggplot objects.
}
\description{
Draws a ridge plot of single cell data (gene expression, metrics, PC
scores, etc.)
}
\examples{
RidgePlot(object = pbmc_small, features.plot = 'PC1')

}
