% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{DotPlot}
\alias{DotPlot}
\alias{SplitDotPlotGG}
\title{Dot plot visualization}
\usage{
DotPlot(object, features, cols = c("lightgrey", "blue"),
  col.min = -2.5, col.max = 2.5, dot.min = 0, dot.scale = 6,
  group.by = NULL, split.by = NULL, scale.by = "radius",
  scale.min = NA, scale.max = NA, ...)
}
\arguments{
\item{object}{Seurat object}

\item{features}{Input vector of features}

\item{cols}{Colors to plot, can pass a single character giving the name of
a palette from \code{RColorBrewer::brewer.pal.info}}

\item{col.min}{Minimum scaled average expression threshold (everything smaller
will be set to this)}

\item{col.max}{Maximum scaled average expression threshold (everything larger
will be set to this)}

\item{dot.min}{The fraction of cells at which to draw the smallest dot
(default is 0). All cell groups with less than this expressing the given
gene will have no dot drawn.}

\item{dot.scale}{Scale the size of the points, similar to cex}

\item{group.by}{Factor to group the cells by}

\item{split.by}{Factor to split the groups by (replicates the functionality of the old SplitDotPlotGG);
see \code{\link{FetchData}} for more details}

\item{scale.by}{Scale the size of the points by 'size' or by 'radius'}

\item{scale.min}{Set lower limit for scaling, use NA for default}

\item{scale.max}{Set upper limit for scaling, use NA for default}

\item{...}{Ignored}
}
\value{
A ggplot object
}
\description{
Intuitive way of visualizing how feature expression changes across different
identity classes (clusters). The size of the dot encodes the percentage of
cells within a class, while the color encodes the AverageExpression level of
cells within a class (blue is high).
}
\examples{
cd_genes <- c("CD247", "CD3E", "CD9")
DotPlot(object = pbmc_small, features = cd_genes)
pbmc_small[['groups']] <- sample(x = c('g1', 'g2'), size = ncol(x = pbmc_small), replace = TRUE)
DotPlot(object = pbmc_small, features = cd_genes, split.by = 'groups')

}
\seealso{
\code{RColorBrewer::brewer.pal.info}
}
