% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/dimensional_reduction.R
\name{ScoreJackStraw}
\alias{ScoreJackStraw}
\alias{ScoreJackStraw.JackStrawData}
\alias{ScoreJackStraw.DimReduc}
\alias{ScoreJackStraw.Seurat}
\title{Compute Jackstraw scores significance.}
\usage{
ScoreJackStraw(object, ...)

\method{ScoreJackStraw}{JackStrawData}(object, dims = 1:5, score.thresh = 1e-05, ...)

\method{ScoreJackStraw}{DimReduc}(object, dims = 1:5, score.thresh = 1e-05, ...)

\method{ScoreJackStraw}{Seurat}(
  object,
  reduction = "pca",
  dims = 1:5,
  score.thresh = 1e-05,
  do.plot = FALSE,
  ...
)
}
\arguments{
\item{object}{An object}

\item{...}{Arguments passed to other methods}

\item{dims}{Which dimensions to examine}

\item{score.thresh}{Threshold to use for the proportion test of PC
significance (see Details)}

\item{reduction}{Reduction associated with JackStraw to score}

\item{do.plot}{Show plot. To return ggplot object, use \code{JackStrawPlot} after
running ScoreJackStraw.}
}
\value{
Returns a Seurat object
}
\description{
Significant PCs should show a p-value distribution that is
strongly skewed to the left compared to the null distribution.
The p-value for each PC is based on a proportion test comparing the number
of features with a p-value below a particular threshold (score.thresh), compared with the
proportion of features expected under a uniform distribution of p-values.
}
\seealso{
\code{\link{JackStrawPlot}}

\code{\link{JackStrawPlot}}
}
\author{
Omri Wurtzel
}
\concept{dimensional_reduction}
