% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_expression.R
\name{PrepSCTFindMarkers}
\alias{PrepSCTFindMarkers}
\title{Prepare object to run differential expression on SCT assay with multiple models}
\usage{
PrepSCTFindMarkers(object, assay = "SCT", verbose = TRUE)
}
\arguments{
\item{object}{Seurat object with SCT assays}

\item{assay}{Assay name where for SCT objects are stored; Default is 'SCT'}

\item{verbose}{Print messages and progress}
}
\value{
Returns a Seurat object with recorrected counts and data in the SCT assay.
}
\description{
Given a merged object with multiple SCT models, this function uses minimum
of the median UMI (calculated using the raw UMI counts) of individual objects
to reverse the individual SCT regression model using minimum of median UMI
as the sequencing depth covariate.
The counts slot of the SCT assay is replaced with recorrected counts and
the data slot is replaced with log1p of recorrected counts.
}
\examples{
data("pbmc_small")
pbmc_small1 <- SCTransform(object = pbmc_small, variable.features.n = 20)
pbmc_small2 <- SCTransform(object = pbmc_small, variable.features.n = 20)
pbmc_merged <- merge(x = pbmc_small1, y = pbmc_small2)
pbmc_merged <- PrepSCTFindMarkers(object = pbmc_merged)
markers <- FindMarkers(
  object = pbmc_merged,
  ident.1 = "0",
  ident.2 = "1",
  assay = "SCT"
)
pbmc_subset <- subset(pbmc_merged, idents = c("0", "1"))
markers_subset <- FindMarkers(
  object = pbmc_subset,
  ident.1 = "0",
  ident.2 = "1",
  assay = "SCT",
  recorrect_umi = FALSE
)

}
\concept{differential_expression}
