% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShapeRotator.R
\name{translate}
\alias{translate}
\title{translate}
\usage{
translate(T, landmark, origin = c(0,0,0))
}
\arguments{
\item{T}{an object of the class "array" that contains three-dimensional
landmarks for 'n' specimens}

\item{landmark}{an integer object that indicates the position of the
three-dimensional landmark that will be used to translate each matrix of
landmarks to the point of origin.}

\item{origin}{a vector that contains three-dimensional coordinates (x, y, z)
indicating where the origin point should be translanted to.}
}
\value{
This function returns a translated T array of dimensions (p, 3, n), in
  which p indicates the number of landmarks, and n the number of specimens
  included in the array. The translated array will keep the dimnames
  associated with each specimen (n).
}
\description{
Translates array T to origin point.
}
\details{
Takes an array T and an index in the array landmark, and translates it to
  the origin. Each structure will be translated to the point of origin so
  that p0 =(0,0,0). We will be translating landmark A from structure 1 and
   landmark D from structure 2 for a single-point articulated rotation.
   And landmark A from structure 1 and landmark E from structure 2 for a
   double rotation (double-point articulated rotation). Thus, the distance
   from the coordinates of landmark A (Ax, Ay, Az) is substracted from all
   the landmarks in all specimens. For example (Nx - Ax, Ny - Ay, Nz - Az)
   for landmark N, for structure 1. For structure 2, the distance from the
   coordinates of landmark D or E depending on the type of rotation. For
   example, in a double rotation, (Ex, Ey, Ez) is substracted from all the
   landmarks in all specimens: (Nx - Ex, Ny - Ey, Nz - Ez). Landmarks A and
   E will equal (0,0,0), so that Ax=Ay=Az=Ex=Ey=Ez=0. The default is to set
   the origin to (0,0,0), but this can be specified to be something else. In
   order to use this function, the landmark data needs to be imported to the
   R environment using geomorph (Adams et al., 2018)
}
\examples{
#Data
data(double_data_1)
data(double_data_2)
data.1 <- double_data_1
data.2 <- double_data_2

#Landmarks
land.a=55
land.b=49
land.c=54
land.d=4

land.e=22
land.f=21
land.g=2
land.h=11

# Translate the data
data.1_t <- translate(data.1, land.a)
data.2_t <- translate(data.2, land.e)

}
\references{
Adams, D. C., M. L. Collyer, and A. Kaliontzopoulou. 2018.
Geomorph: Software for geometric morphometric analysis. R package version
3.0.6. Available at http://CRAN.R-project.org/package=geomorph.

M. Vidal-García, L. Bandara and J.S. Keogh. 2018. ShapeRotator: An R tool
for standardized rigid rotations of articulated three-dimensional
structures with application for geometric morphometrics.
Ecology and Evolution. DOI: 10.1002/ece3.4018
}
\author{
Marta Vidal-Garcia
}
