#' Clinical outcomes in multiple sclerosis patients dataset
#'
#' @description The `MSclinical` dataset contains clinical measures on multiple sclerosis patients.
#'
#' @references Rasova, K., Martinkova, P., Vyskotova, J., & Sedova, M. (2012).
#' Assessment set for evaluation of clinical outcomes in multiple sclerosis: Psychometric properties.
#' Patient related outcome measures, 3, 59. \doi{10.2147/PROM.S32241}
#'
#' @keywords datasets
#'
#' @format `MSclinical` is a `data.frame` consisting of 17 observations on
#'   13 variables.
#'   \describe{
#'   \item{LCLA}{Low-Contrast Letter Acuity test.  }
#'   \item{MI}{Motricity Index. }
#'   \item{MAS}{Modified Ashworth Scale. }
#'   \item{BBS}{Berg Balance Scale. }
#'   \item{T}{Tremor. }
#'   \item{DD}{Dysdiadochokinesia. }
#'   \item{DM}{Dysmetria. }
#'   \item{PRs}{Postural reactions. }
#'   \item{KH}{Knee Hyperextension. }
#'   \item{NHPT}{Nine-Hole Peg Test. }
#'   \item{T25FW}{Timed 25-Foot Walk. }
#'   \item{PASAT3}{3-minute version of the Paced Auditory Serial Addition Test. }
#'   \item{EDSS}{Kurtzke Expanded Disability Status Scale. }
#' }
"MSclinical"
