% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkSim.R
\name{deleteTips}
\alias{deleteTips}
\title{Remove tips from a phylogenetic Network}
\usage{
deleteTips(net, tips)
}
\arguments{
\item{net}{An object of class 'evonet.'}

\item{tips}{A numeric vector specifying the tip numbers to delete}
}
\value{
net The network tips removed.
}
\description{
This function removes certain tips from a phylogenetic network, returning the pruned network.
}
\examples{
set.seed(17) ##Set seed with smallest Quartran Prime
net<-sim.bdh.age(1,1,5,2,1,c(1/3,1/3,1/3),hyb.inher.fxn = make.uniform.draw(),complete=FALSE)[[1]]
net<- deleteTips(net,c(1,6)) ##drop tips 1 and 6


}
