% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mito.R
\name{FindClonotypes}
\alias{FindClonotypes}
\title{Find clonotypes}
\usage{
FindClonotypes(
  object,
  assay = NULL,
  features = NULL,
  metric = "cosine",
  resolution = 1,
  k = 10,
  algorithm = 3
)
}
\arguments{
\item{object}{A Seurat object}

\item{assay}{Name of assay to use}

\item{features}{Features to include when constructing neighbor graph}

\item{metric}{Distance metric to use}

\item{resolution}{Clustering resolution to use. See
\code{\link[Seurat]{FindClusters}}}

\item{k}{Passed to \code{k.param} argument in
\code{\link[Seurat]{FindNeighbors}}}

\item{algorithm}{Community detection algorithm to use. See
\code{\link[Seurat]{FindClusters}}}
}
\value{
Returns a \code{\link[Seurat]{Seurat}} object
}
\description{
Identify groups of related cells from allele frequency data. This will
cluster the cells based on their allele frequencies, reorder the factor
levels for the cluster identities by heirarchically clustering the collapsed
(pseudobulk) cluster allele frequencies, and set the variable features for
the allele frequency assay to the order of features defined by heirarchal
clustering.
}
\concept{mito}
