% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/footprinting.R
\name{InsertionBias}
\alias{InsertionBias}
\alias{InsertionBias.ChromatinAssay}
\alias{InsertionBias.Seurat}
\title{Compute Tn5 insertion bias}
\usage{
InsertionBias(object, ...)

\method{InsertionBias}{ChromatinAssay}(object, genome, region = "chr1-1-249250621", verbose = TRUE, ...)

\method{InsertionBias}{Seurat}(
  object,
  genome,
  assay = NULL,
  region = "chr1-1-249250621",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{A Seurat or ChromatinAssay object}

\item{...}{Additional arguments passed to \code{\link{StringToGRanges}}}

\item{genome}{A \code{BSgenome} object or any other object supported by
\code{getSeq}. Do \code{showMethods("getSeq")} to get the list of all
supported object types.}

\item{region}{Genomic region to use when assessing bias.}

\item{verbose}{Display messages}

\item{assay}{Name of assay to use}
}
\value{
Returns a Seurat object
}
\description{
Counts the Tn5 insertion frequency for each DNA hexamer.
}
\examples{
\dontrun{
library(BSgenome.Mmusculus.UCSC.mm10)

region.use <- GRanges(
  seqnames = c('chr1', 'chr2'),
  IRanges(start = c(1,1), end = c(195471971, 182113224))
)

InsertionBias(
 object = atac_small,
 genome = BSgenome.Mmusculus.UCSC.mm10,
 region = region.use
)
}
}
\concept{footprinting}
