% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SignacFast.R
\name{SignacFast}
\alias{SignacFast}
\title{Fast classification of cellular phenotypes}
\usage{
SignacFast(
  E,
  Models = "default",
  spring.dir = NULL,
  num.cores = 1,
  threshold = 0,
  smooth = TRUE,
  impute = TRUE,
  verbose = TRUE,
  do.normalize = TRUE,
  return.probability = FALSE
)
}
\arguments{
\item{E}{a gene (rows) by cell (column) matrix, sparse matrix or a Seurat object. Rows are HUGO symbols.}

\item{Models}{if 'default', as returned by \code{\link{GetModels_HPCA}}. An ensemble of 1,800 neural network models.}

\item{spring.dir}{If using SPRING, directory to categorical_coloring_data.json. Default is NULL.}

\item{num.cores}{number of cores to use for parallel computation. Default is 1.}

\item{threshold}{Probability threshold for assigning cells to "Unclassified." Default is 0.}

\item{smooth}{if TRUE, smooths the cell type classifications. Default is TRUE.}

\item{impute}{if TRUE, gene expression values are imputed prior to cell type classification (see \code{\link{KSoftImpute}}). Default is TRUE.}

\item{verbose}{if TRUE, code will report outputs. Default is TRUE.}

\item{do.normalize}{if TRUE, cells are normalized to the mean library size. Default is TRUE.}

\item{return.probability}{if TRUE, returns the probability associated with each cell type label. Default is TRUE.}
}
\value{
A list of character vectors: cell type annotations (L1, L2, ...) at each level of the hierarchy
as well as 'clusters' for the Louvain clustering results.
}
\description{
\code{SignacFast} uses pre-computed neural network models to classify cellular phenotypes in single cell data:
these models were pre-trained with the HPCA training data. Any features that are
present in the training data and absent in the single cell data are set to zero. 
This is a factor of ~5-10 speed improvement over \code{\link{Signac}}.
}
\examples{
\dontrun{
# download single cell data for classification
file.dir = "https://cf.10xgenomics.com/samples/cell-exp/3.0.0/pbmc_1k_v3/"
file = "pbmc_1k_v3_filtered_feature_bc_matrix.h5"
download.file(paste0(file.dir, file), "Ex.h5")

# load data, process with Seurat
library(Seurat)
E = Read10X_h5(filename = "Ex.h5")
pbmc <- CreateSeuratObject(counts = E, project = "pbmc")
pbmc <- SCTransform(pbmc)
pbmc <- RunPCA(pbmc, verbose = FALSE)
pbmc <- RunUMAP(pbmc, dims = 1:30, verbose = FALSE)
pbmc <- FindNeighbors(pbmc, dims = 1:30, verbose = FALSE)

# classify cells
labels = SignacFast(E = pbmc)
celltypes = GenerateLabels(labels, E = pbmc)

# add labels to Seurat object, visualize
lbls <- factor(celltypes$CellStates)
levels(lbls) <- sort(unique(lbls))
pbmc <- AddMetaData(pbmc, metadata=celltypes$CellStates, col.name = "celltypes")
pbmc <- SetIdent(pbmc, value='celltypes')
DimPlot(pbmc, label = T)

# save results
saveRDS(pbmc, "pbmcs.rds")
saveRDS(celltypes, "celltypes.rds")
}
}
\seealso{
\code{\link{Signac}} for another classification function.

\code{\link{Signac}}
}
