% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimEUCartelLaw.r
\name{LEgame}
\alias{LEgame}
\title{Simulate the Legal Exemption Game}
\usage{
LEgame(params, m = 1e+05, corrMat = diag(7), QMC = FALSE, seed = 1)
}
\arguments{
\item{params}{named list containing numeric vectors Phi, Rho, Chi, 
Ksi, M, G and A with the ranges for the input parameters.}

\item{m}{numeric scalar containing the number of Monte Carlo
replications. Defaults to \code{1e5}.}

\item{corrMat}{matrix containing the correlation matrix for the
simulation. Defaults to a 7x7 identity matrix.}

\item{QMC}{logical scalar. If \code{TRUE}, an equidistant grid is
generated, if \code{FALSE}, uniformly distributed random numbers are
simulated.}

\item{seed}{numeric scalar containing the random seed for the
simulation. Defaults to \code{1} in order to make results reproducible.}
}
\value{
A dataframe  containing the realized output of the simulation.
}
\description{
\code{LEgame} simulates the legal exemption game.
}
\details{
\code{LEgame} simulates the deterrent effect of the European cartel law 
based on a game-theoretic model for the legal exemption system.
}
\examples{
Par <- list(Phi=c(0.1,0.5), Rho=c(0.5,0.9), Ksi=c(0.05,0.3), Chi=c(0.1,0.4),
            M=c(0.2,1.2), G=c(0.05,0.2), A=c(0.1,0.3))
res <- LEgame(params=Par, m=100000)
print(aggResults(res))

}
