% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RNV.mean.suitability.R
\name{RNV.mean.suitability}
\alias{RNV.mean.suitability}
\title{Compare RNV mean in simulation with predicted RNV at equilibrium}
\usage{
RNV.mean.suitability(all_res_sim,end.mean=TRUE,which.sim=NULL,
new.window=FALSE,posi.legend="topleft",...)
}
\arguments{
\item{all_res_sim}{List, the output of function \code{\link{simul.evol.enz.multiple}} (results of evolution simulation).}

\item{end.mean}{Logical. If \code{FALSE}, compute RNV size mean for all rows of \code{res_sim}. If \code{TRUE}, compute RNV size mean for last half of \code{res_sim} rows.}

\item{which.sim}{Numeric vector containing integer numbers between 1 and \code{nsim}. Which simulations would you represent? If \code{NULL} (default), all simulations would be represented.}

\item{new.window}{Logical. Do graphics appear in a new window?}

\item{posi.legend}{Character string. Where would you put the legend? See parameter \code{x} in function \code{legend}. If \code{NULL}, legend will not appear.}

\item{...}{Arguments to be passed in \code{plot} function, such as \code{lwd} or \code{cex}.}
}
\value{
Invisible list of 6 elements:
\itemize{
   \item \code{$RNV_mean_simul}: numeric matrix of \code{n+2} columns and number of rows is between \code{nsim} and \code{2*nsim} (depending on RNV number).
   \code{n} first columns contain RNV mean for corresponding enzyme. Column \code{n+1} indicates simulation number and column \code{n+2} the RNV number (1 for near RNV and 2 for far RNV).
   \item \code{$list_eq_all}: list of \code{nsim} elements. Each element \code{s} is the output of function \code{\link{RNV.size.at.equilibr}} for simulation \code{s}
   \item \code{$RNV_at_eq}: numeric matrix of \code{n+1} columns and \code{nsim} rows.
   \code{n} first columns correspond to RNV size at predicted equilibrium for corresponding enzyme. Column \code{n+1} indicates simulation number.
   \item \code{$lm_compar_RNV}: object of \code{class "lm"}. Linear model of RNV mean for near RNV (RNV number 1) in relation to RNV at predicted equilibrium.
   \item \code{$A_mean}: numeric matrix of \code{n} columns (enzyme) and \code{nsim} rows (simulation). Each cell is the activity mean for each enzyme (in column) and each simulation (in row).
   \item \code{$Etot_mean}: numeric vector of length \code{nsim}. Each value is the total concentration mean for each simulation.
}
}
\description{
Compare RNV mean in simulation with predicted RNV at equilibrium to measure suitability of RNV mean as a proxy of RNV at equilibrium
With a graph and a linear model.
}
\details{
Function \code{RNV.mean.suitability} computes mean of RNV size by enzyme, using function \code{\link{RNV.mean.simul}}.
It computes also the RNV size around predicted equilibrium, using function \code{\link{RNV.size.at.equilibr}}.
Then \code{RNV.mean.suitability} plots the RNV means in relation to predicted RNVs for every enzyme and every simulation.

\code{RNV.mean.suitability} computes also a linear model of RNV means in relation to RNV size at equilibrium, for selected simulations only (by setting \code{which.sim}).
  
Each simulation corresponds to one color. Colors for simulations are taken in palette \code{rainbow}.
Displayed number is the enzyme number.
Black line is the linear model. Dashed line is the symmetry line.

 Function \code{RNV.mean.suitability} is designed to compute mean RNV from simulations launched by \code{\link{simul.evol.enz.multiple}}.
Input \code{all_res_sim} is the output of \code{\link{simul.evol.enz.multiple}}.
}
\examples{

# With saved simulation
data(data_sim_SC)
RNV.mean.suitability(data_sim_SC,new.window=TRUE,which.sim=c(1,4,6))

\donttest{
data(data_sim_RegNeg)
RNV.mean.suitability(data_sim_RegNeg,new.window=TRUE)
}


}
\seealso{
Function \code{\link{RNV.for.simul}} is used to compute RNV. 

Function \code{\link{RNV.mean.simul}} is used to compute RNV mean for each simulation.

Function \code{\link{RNV.size.at.equilibr}} is used to compute RNV at equilibrium.
}
