% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/SimInf_model.R
\docType{methods}
\name{V<-}
\alias{V<-}
\alias{V<-,SimInf_model-method}
\title{Set a template for where to write the V result matrix}
\usage{
V(model) <- value

\S4method{V}{SimInf_model}(model) <- value
}
\arguments{
\item{model}{The \code{model} to set a template for the result
matrix \code{V}.}

\item{value}{Write the real-valued continuous state at
\code{tspan} to the non-zero elements in \code{value}, where
\code{value} is a sparse matrix, \code{dgCMatrix}, with
dimension \eqn{N_n}\code{dim(ldata)[1]} \eqn{\times}
\code{length(tspan)}. Default is \code{NULL} i.e. to write the
real-valued continuous state to a dense matrix.}
}
\description{
Set a template for where to write the V result matrix
}
\examples{
## Create an 'SISe' model with 6 nodes and initialize
## it to run over 10 days.
u0 <- data.frame(S = 100:105, I = 1:6)
model <- SISe(u0 = u0, tspan = 1:10, phi = rep(0, 6),
    upsilon = 0.02, gamma = 0.1, alpha = 1, epsilon = 1.1e-5,
    beta_t1 = 0.15, beta_t2 = 0.15, beta_t3 = 0.15, beta_t4 = 0.15,
    end_t1 = 91, end_t2 = 182, end_t3 = 273, end_t4 = 365)

## An example with a sparse V result matrix, which can save a lot
## of memory if the model contains many nodes and time-points, but
## where only a few of the data points are of interest. First
## create a sparse matrix with non-zero entries at the locations
## in V where the continuous state variables should be written. Then
## run the model with the sparse matrix as a template for V where
## to write data.
m <- Matrix::sparseMatrix(1:6, 5:10)
V(model) <- m
result <- run(model, threads = 1, seed = 7)

## Extract the continuous state variables at the time-points in tspan.
V(result)
}
\keyword{methods}
