% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse.R
\name{wrap_all_in_trycatch}
\alias{wrap_all_in_trycatch}
\alias{wrap_all_in_preserve_seed}
\title{Wrappers around Analyse Functions}
\usage{
wrap_all_in_trycatch(
  list_of_functions,
  error = function(e) {
     warning(e$message)
     NA
 }
)

wrap_all_in_preserve_seed(list_of_functions)
}
\arguments{
\item{list_of_functions}{the list of functions to be wrapped}

\item{error}{the error function in the tryCatch call}
}
\value{
a list of functions
}
\description{
Wrappers around Analyse Functions
}
\details{
SimDesign redraws data if one analysis function fails. This is not
only highly inefficient for large studies, but failure of a method is
informative and might be of interest. Moreover redrawing of data might
introduce bias if the failure of the method is not independent of the
parameter value, which would be a strong assumption.

To avoid redrawing data, we can catch all errors the analysis methods could
throw and return \code{NA} instead.

This is handled well by the summarise functions generated with
\code{create_summarise_function} other summarise functions might throw errors
when trying to \code{rbind} a data.frame to a scalar \code{NA} value. In this case
add another \code{error} argument. For example \verb{\\(e)\{NULL\}} could work in some
cases, in other cases you'll have to give a function that returns a
data.frame with the same columns as the analyse functions and only NA
values.

Analysis functions might use random numbers. If simulations should
be replicated this can interfere with the RNG state of other analysis
functions. To avoid this you can wrap all analysis function in a
\code{withr::with_preserve_seed} call, so that the RNG state is reset after each
analysis function is called. This way adding, removing or changing one
analysis function has no effect on the other analysis functions, even if
the analysis functions use random numbers.
}
\section{Functions}{
\itemize{
\item \code{wrap_all_in_trycatch()}: Wrap all functions in a list in tryCatch calls

\item \code{wrap_all_in_preserve_seed()}: wrap all functions in \code{withr::with_preserve_seed}

}}
\examples{
funs1 <- list(\(){stop("test")}, \(){1})
funs2 <- wrap_all_in_trycatch(funs1)
try(lapply(funs1, \(f){f()}))
try(lapply(funs2, \(f){f()}))

funs1 <- list(\(){rnorm(1)})
funs2 <- list(\(){runif(1)}, \(){rnorm(1)})
funs3 <- funs2 |> wrap_all_in_preserve_seed()
set.seed(1)
lapply(funs1, \(f){f()})
set.seed(1)
lapply(funs2, \(f){f()})
set.seed(1)
lapply(funs3, \(f){f()})
}
