test_that("simulation runs with simInit and spades", {
  library(igraph); on.exit(detach(package:igraph))

  set.seed(42)

  times <- list(start=0.0, end=10, timeunit="year")
  params <- list(
    .globals=list(burnStats="npixelsburned", stackName="landscape"),
    randomLandscapes=list(.plotInitialTime=NA, .plotInterval=NA),
    caribouMovement=list(.plotInitialTime=NA, .plotInterval=NA, torus=TRUE),
    fireSpread=list(.plotInitialTime=NA, .plotInterval=NA)
  )
  modules <- list("randomLandscapes", "caribouMovement", "fireSpread")
  paths <- list(modulePath=system.file("sampleModules", package="SpaDES"))

  mySim <- simInit(times, params, modules, objects=list(), paths) %>% spades

  # simtime
  expect_equivalent(time(mySim), 10.0)
  expect_equivalent(start(mySim), 0.0)
  expect_equivalent(end(mySim), 10.0)

  # sim results
  burnedLast <- c(1680, 1485, 607, 1079, 1041, 605, 871, 1097, 495, 1253)

  pos_x <- c(
    -36.9964594878183, 2.32458656754471, 30.12442850383, -18.6640229184998,
    -33.8885207519506, -29.5427930908878, -21.0095214973779, -6.42587067738999,
    -5.07663946918247, 1.51100547592112, 40.1425992497513, -40.0937640741396,
    8.4223912961982, -28.2165542018589, -23.0437975158775, 18.294604333076,
    -16.7308043319382, -8.47854059870558, 39.0343113708618, -39.3309621495378,
    -3.85775142502581, 49.0817194947727, -17.9722065247698, 4.55173210595375,
    -41.0519469414064, 34.8930158926542, -32.589908783801, -40.5387963961559,
    34.2194237750273, -33.5059996554471, 41.7214409962314, -33.4975937591762,
    -16.7534188285129, -3.15227992913145, 23.6589792431533, 28.0041852235432,
    43.3963008307616, 15.6253468583625, -24.338203383424, 38.3698431106254,
    -8.95270144561675, 33.179905218285, -32.412733860245, 35.8000608503506,
    32.1821466587538, -5.44818140354121, 34.3391843159336, -1.11939974258066,
    -29.9411578108715, -8.4957082608383, 38.4884378359319, -44.6014019956853,
    9.52576850503965, -29.621391887535, -3.42226265233396, -48.0427755267367,
    -48.0453925992576, 31.3356691703378, 39.4370108644243, -23.0450600175721,
    -29.9676867807934, -14.984320542406, 13.0752058955144, 11.8531604473534,
    -24.9697318775997, -25.3771063203708, 46.0558653502021, 27.1583913421414,
    47.0730137699115, -43.2589915711839, 34.287440364578, -16.462781379318,
    13.8025952614028, 7.98145114328579, 12.6617467700004, 8.6529212125842,
    42.9266926532228, -29.6405295858366, 35.0331975539472, 22.782823127803,
    -33.6543726032234, -9.20996524772551, 6.86344094726754, -42.0192917407262,
    41.097913592971, 9.11335978963641, 35.7427369785196, 1.39434498353882,
    25.6514918771879, -25.7249927901813, 46.5803504144238, -46.9702484362805,
    30.3177776221904, 11.1446124689632, 46.5656200410542, 42.6072217133873,
   -26.5944387764709, 30.3706355061775, -39.2953280003378, -6.61414387806415
  )

  pos_y <- c(
    11.2259177001642, -48.2749285467045, -19.2693150119305, -30.1955629122566,
    -5.16274098908813, 19.7263653977621, -18.3682115225133, 11.738367415035,
    38.9967732966357, 2.71795967614925, -44.7225009655404, -32.6275290676451,
    -14.7686749801842, 25.2266058813999, 43.367709252435, 40.625866000042,
    22.0714768248821, -24.1975134747756, -24.2623383782744, -12.5286480447744,
    48.122230154392, -44.8308278925359, 37.0642433839201, -15.6006743461834,
    -28.265637676497, 8.5281444890346, 37.3382373812721, 30.2225238433243,
    -26.9394661142134, 29.4716759594875, -43.5670094907836, -47.8084247612384,
    -48.1749534451242, -45.1487680482165, -30.8568223487393, -39.0221779181183,
    -15.806612632621, 9.37725216531152, -40.2347020337625, 19.3362330671687,
    10.0653991235251, -24.599586469326, -35.8913143320209, 35.6277170387067,
    35.5608652339012, -36.7887704649442, -5.75447090913782, 1.01447582952702,
    12.9836719196659, -18.5773516046411, -46.6496786531966, -22.4229092556123,
    35.9359685267436, 45.2300691122058, 25.6432668008571, 41.3834115900633,
    -13.4068360644368, -26.1410488438946, -47.4071373813623, -32.2387795954974,
    -35.7842792759393, -7.70426791095162, 36.0018667789867, 30.1562830869532,
    41.6895906080711, 47.8520336608373, 3.57737369062482, -39.6190773865091,
    5.37402201117737, -37.3107079155598, -34.1742440396536, -19.2538176414933,
    -48.6308373737092, -26.392445100473, -41.039612082825, -46.6119580572095,
    -16.844154891972, -26.0741751607543, -31.4374762519959, -6.44047912640615,
    44.8723281786276, -43.6527354527293, 37.8112535875202, -22.5498526193275,
    25.9669403382768, 1.16676526552681, -30.6497237706147, 32.5573215765397,
    15.4977777956788, 20.7609180017956, 31.0985715416653, -34.7622261504206,
    18.6274139594293, 43.0727309557879, -18.0134694585456, 39.5790564364162,
    12.5097325118235, -31.4932896470479, 37.7529892755605, -30.960625150814
  )

  expect_equal(mySim$npixelsburned, burnedLast)
  expect_equivalent(mySim$caribou$x, pos_x)
  expect_equivalent(mySim$caribou$y, pos_y)
})
